/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.accesscontrol.impl;

import com.vmware.cis.authz.Permission;
import com.vmware.cis.authz.Privilege;
import com.vmware.cis.authz.Role;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.vim.security.AuthorizationObjectUtil;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationServiceImpl
implements AuthorizationService {
    private static final Log _logger = LogFactory.getLog(AuthorizationServiceImpl.class);
    private static final String DOC_ID_PREFIX = "urn:vmomi:";
    private static final String ANY_TYPE = "Any";
    private final Permission _permissionManager;
    private final Privilege _privilegeManager;
    private final Role _roleManager;
    private final ObjectReferenceService _objRefSvc;

    public AuthorizationServiceImpl(Permission permission, Privilege privilege, Role role, ObjectReferenceService objectReferenceService) {
        this._permissionManager = permission;
        this._privilegeManager = privilege;
        this._roleManager = role;
        this._objRefSvc = objectReferenceService;
        _logger.debug((Object)"instantiated");
    }

    @Override
    public DynamicID getReferenceId(Object object) {
        int n;
        if (AuthorizationObjectUtil.ROOT_NODE_URI.equals(object)) {
            return AuthorizationObjectUtil.AUTH_SERVICE_ROOT;
        }
        String string = this._objRefSvc.getUid(object);
        DynamicID dynamicID = new DynamicID();
        if (string.startsWith(DOC_ID_PREFIX) && (n = string.indexOf(58, DOC_ID_PREFIX.length())) != -1) {
            dynamicID.setId(string.substring(n + 1));
            dynamicID.setType(string.substring(DOC_ID_PREFIX.length(), n));
            return dynamicID;
        }
        dynamicID.setId(string);
        dynamicID.setType(ANY_TYPE);
        return dynamicID;
    }

    @Override
    public Object getReference(DynamicID dynamicID) {
        Object object = null;
        if (AuthorizationObjectUtil.AUTH_SERVICE_ROOT.equals((Object)dynamicID)) {
            object = AuthorizationObjectUtil.ROOT_NODE_URI;
        } else if (ANY_TYPE.equals(dynamicID.getType())) {
            object = this._objRefSvc.getReference(dynamicID.getId());
        } else {
            String string = DOC_ID_PREFIX + dynamicID.getType() + ":" + dynamicID.getId();
            object = this._objRefSvc.getReference(string);
        }
        return object;
    }

    @Override
    public Permission getPermissionManger() {
        return this._permissionManager;
    }

    @Override
    public Privilege getPrivilegeManager() {
        return this._privilegeManager;
    }

    @Override
    public Role getRoleManager() {
        return this._roleManager;
    }
}

