/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.accesscontrol.impl;

import com.vmware.vise.data.provider.DelegatingServiceBase;
import com.vmware.vise.data.provider.ProviderMethodNotFoundException;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationService;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationServiceManager;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationServiceProvider;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationServiceManagerImpl
implements AuthorizationServiceManager {
    private static final String AUTHZ_SERVICE = "getService";
    private static final String AUTHZ_SOLUTION_SERVICE = "getSolutionService";
    private static final Log _logger = LogFactory.getLog(AuthorizationServiceManagerImpl.class);
    private DelegatingServiceBase _delegatingService;

    public AuthorizationServiceManagerImpl(ServiceRegistry serviceRegistry) {
        this._delegatingService = new DelegatingServiceBase(AuthorizationServiceProvider.class, serviceRegistry);
    }

    @Override
    public AuthorizationService getService(Object object) {
        try {
            return this.getService(object, AUTHZ_SERVICE);
        }
        catch (Exception exception) {
            _logger.error((Object)"Faled getting an AuthZ user client: ", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public AuthorizationService getSolutionService(Object object) {
        try {
            return this.getService(object, AUTHZ_SOLUTION_SERVICE);
        }
        catch (Exception exception) {
            _logger.error((Object)"Faled getting an AuthZ solution client: ", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private AuthorizationService getService(Object object, String string) throws IllegalAccessException, InvocationTargetException {
        AuthorizationService authorizationService = null;
        if (object != null) {
            try {
                authorizationService = (AuthorizationService)this._delegatingService.delegate(string, new Object[]{object});
            }
            catch (ProviderMethodNotFoundException providerMethodNotFoundException) {
                authorizationService = (AuthorizationService)this._delegatingService.delegate(string, new Object[0]);
            }
        } else {
            authorizationService = (AuthorizationService)this._delegatingService.delegate(string, new Object[0]);
        }
        return authorizationService;
    }
}

