/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.accesscontrol.impl;

import com.vmware.cis.authorization.client.exception.AuthorizationClientException;
import com.vmware.cis.authz.Permission;
import com.vmware.cis.authz.PermissionTypes;
import com.vmware.cis.authz.Privilege;
import com.vmware.cis.authz.PrivilegeTypes;
import com.vmware.cis.authz.Role;
import com.vmware.cis.authz.RoleTypes;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vapi.std.errors.Unauthorized;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationService;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationServiceManager;
import com.vmware.vise.vim.security.accesscontrol.PrivilegeCache;
import com.vmware.vise.vim.security.data.PermissionData;
import com.vmware.vise.vim.security.data.PermissionInfo;
import com.vmware.vise.vim.security.data.PrivilegeData;
import com.vmware.vise.vim.security.data.PrivilegeInfo;
import com.vmware.vise.vim.security.data.RoleData;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.util.VCAuthorizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationServicePropertyAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(AuthorizationServicePropertyAdapter.class);
    private static final String ENTITY_PERMISSION = "entityPermission";
    private static final String SYSTEM_PRIVILEGES = "systemPrivileges";
    private static final String ROLES_INFO = "rolesInfo";
    private static final String HAS_PRIVILEGES = "hasPrivileges";
    private static final String AUTHZ_ROLE_CACHE_KEY_PREFIX = "authUtilRoleCache:";
    private static final int AUTHZ_ROLE_CACHE_DURATION_MS = 5000;
    private static final String PRIVILEGES_CACHE_KEY = "privileges.cache.key";
    private final AuthorizationServiceManager _authzMgr;
    private final PrivilegeCache _privilegeCache;
    private final ObjectReferenceService _objectReferenceSvc;

    public AuthorizationServicePropertyAdapter(AuthorizationServiceManager authorizationServiceManager, DataServiceExtensionRegistry dataServiceExtensionRegistry, PrivilegeCache privilegeCache, ObjectReferenceService objectReferenceService) {
        this._authzMgr = authorizationServiceManager;
        this._privilegeCache = privilegeCache;
        this._objectReferenceSvc = objectReferenceService;
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = "*";
        typeInfo.properties = new String[]{"grantedPrivileges", SYSTEM_PRIVILEGES, ENTITY_PERMISSION, ROLES_INFO, HAS_PRIVILEGES};
        return new TypeInfo[]{typeInfo};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        Object object;
        ResultSet resultSet = new ResultSet();
        Object[] objectArray = propertyRequestSpec.objects;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        Set<String> set = AuthorizationServicePropertyAdapter.extractProperties(propertyRequestSpec.properties);
        if (set.size() == 0) {
            return null;
        }
        ArrayList<List<PropertyValue>> arrayList = new ArrayList<List<PropertyValue>>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(new LinkedList());
        }
        for (String string : set) {
            if ("grantedPrivileges".equals(string)) {
                object = this.getGrantedPrivileges(objectArray);
                this.updateValues(arrayList, (Object[])object, "grantedPrivileges");
                continue;
            }
            if (SYSTEM_PRIVILEGES.equals(string)) {
                object = this.getSystemPrivileges(objectArray);
                this.updateValues(arrayList, (Object[])object, SYSTEM_PRIVILEGES);
                continue;
            }
            if (ENTITY_PERMISSION.equals(string)) {
                object = this.getEntityPermission(objectArray);
                this.updateValues(arrayList, (Object[])object, ENTITY_PERMISSION);
                continue;
            }
            if (ROLES_INFO.equals(string)) {
                object = this.getRolesInfo(objectArray);
                this.updateValues(arrayList, (Object[])object, ROLES_INFO);
                continue;
            }
            if (HAS_PRIVILEGES.equals(string)) {
                object = this.processHasPrivileges(propertyRequestSpec);
                this.updateValues(arrayList, (Object[])object, HAS_PRIVILEGES);
                continue;
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug((Object)("Unsupported property: " + string));
        }
        ResultItem[] resultItemArray = new ResultItem[objectArray.length];
        for (int i = 0; i < resultItemArray.length; ++i) {
            object = (List)arrayList.get(i);
            resultItemArray[i] = new ResultItem();
            resultItemArray[i].resourceObject = objectArray[i];
            resultItemArray[i].properties = object.toArray(new PropertyValue[object.size()]);
        }
        resultSet.items = resultItemArray;
        return resultSet;
    }

    private Boolean[] processHasPrivileges(PropertyRequestSpec propertyRequestSpec) {
        for (PropertySpec propertySpec : propertyRequestSpec.properties) {
            for (String string : propertySpec.propertyNames) {
                if (!HAS_PRIVILEGES.equals(string)) continue;
                if (ArrayUtil.isNullOrEmpty((Object[])propertySpec.parameters)) {
                    Object[] objectArray = new Boolean[propertyRequestSpec.properties.length];
                    Arrays.fill(objectArray, Boolean.TRUE);
                    return objectArray;
                }
                if (propertySpec.parameters.length > 1) {
                    throw new IllegalArgumentException("More than one parameter for hasPrivileges property: " + propertySpec.parameters.length);
                }
                Object[] objectArray = (Object[])propertySpec.parameters[0].parameter;
                String[] stringArray = (String[])Arrays.copyOf(objectArray, objectArray.length, String[].class);
                return this.getHasPrivileges(propertyRequestSpec.objects, stringArray);
            }
        }
        assert (false) : "Unreachable code.";
        return null;
    }

    private void updateValues(List<List<PropertyValue>> list, Object[] objectArray, String string) {
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            List<PropertyValue> list2 = list.get(i);
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.propertyName = string;
            propertyValue.value = objectArray[i];
            list2.add(propertyValue);
        }
    }

    private void checkServerGuids(Object[] objectArray) {
        String string = this._objectReferenceSvc.getServerGuid(objectArray[0]);
        String string2 = null;
        for (int i = 1; i < objectArray.length; ++i) {
            string2 = this._objectReferenceSvc.getServerGuid(objectArray[i]);
            if (StringUtils.equals((String)string, (String)string2)) continue;
            _logger.warn((Object)("Objects with different server GUIDs found: " + string + " and " + string2 + " in the list of objects: " + Arrays.deepToString(objectArray)));
            break;
        }
    }

    public String[][] getGrantedPrivileges(Object[] objectArray) {
        Object object;
        String[][] stringArray = this._privilegeCache.get(objectArray);
        if (stringArray != null) {
            return stringArray;
        }
        this.checkServerGuids(objectArray);
        stringArray = new String[objectArray.length][];
        String string = SsoUtil.getUser();
        Set set = SsoUtil.getGroups();
        AuthorizationService authorizationService = this._authzMgr.getService(objectArray[0]);
        LinkedList<DynamicID> linkedList = new LinkedList<DynamicID>();
        for (Object object2 : objectArray) {
            linkedList.add(authorizationService.getReferenceId(object2));
        }
        Object object3 = null;
        try {
            PrivilegeTypes.BatchQuerySpec batchQuerySpec = new PrivilegeTypes.BatchQuerySpec();
            batchQuerySpec.setResourceId(linkedList);
            batchQuerySpec.setUserName(string);
            batchQuerySpec.setGroupName(new LinkedList(set));
            object = authorizationService.getPrivilegeManager();
            object3 = object.batchQuery(batchQuerySpec);
        }
        catch (Unauthorized unauthorized) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"No privilege to get privilege list for multiple objects.", (Throwable)unauthorized);
            }
            return stringArray;
        }
        for (int i = 0; i < object3.size(); ++i) {
            object = (List)object3.get(i);
            stringArray[i] = object.toArray(new String[object.size()]);
        }
        this._privilegeCache.put(objectArray, stringArray);
        return stringArray;
    }

    public String[] getGrantedPrivileges(Object object) {
        String[][] stringArray = this.getGrantedPrivileges(new Object[]{object});
        return stringArray[0];
    }

    public PrivilegeInfo[] getSystemPrivileges(Object[] objectArray) {
        String string2;
        Collection<String> collection;
        ArrayList arrayList;
        block5: {
            arrayList = new ArrayList();
            Object object = objectArray[0];
            AuthorizationService authorizationService = this._authzMgr.getSolutionService(object);
            collection = null;
            try {
                collection = this.getPrivilegesSecurely(object, authorizationService);
            }
            catch (Unauthorized unauthorized) {
                if (!_logger.isDebugEnabled()) break block5;
                _logger.debug((Object)"No privilege to get the system privilege list", (Throwable)unauthorized);
            }
        }
        if (collection == null) {
            return new PrivilegeInfo[0];
        }
        PrivilegeData[] privilegeDataArray = new PrivilegeData[collection.size()];
        int n = 0;
        for (String string2 : collection) {
            privilegeDataArray[n] = this.createPrivilegeData(string2);
            AuthorizationUtil.addPrivilegeLocalizationKeys((String)privilegeDataArray[n].id, arrayList);
            AuthorizationUtil.addGroupLocalizationKeys((String)privilegeDataArray[n].group, arrayList);
            ++n;
        }
        Map map = LocalizationUtil.getLocalizedMessage((String[])arrayList.toArray(new String[0]), (KeyAnyValue[][])null);
        string2 = new PrivilegeInfo();
        ((PrivilegeInfo)string2).properties = map;
        ((PrivilegeInfo)string2).privilegeData = privilegeDataArray;
        PrivilegeInfo[] privilegeInfoArray = new PrivilegeInfo[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            privilegeInfoArray[i] = string2;
        }
        return privilegeInfoArray;
    }

    private PrivilegeData createPrivilegeData(String string) {
        PrivilegeData privilegeData = new PrivilegeData();
        privilegeData.id = privilegeData.description = string;
        privilegeData.name = privilegeData.description;
        privilegeData.group = this.privilegeGroupFromName(privilegeData.name);
        return privilegeData;
    }

    private String privilegeGroupFromName(String string) {
        if (string == null) {
            return null;
        }
        return string.substring(0, string.lastIndexOf(46));
    }

    public PrivilegeInfo getSystemPrivileges(Object object) {
        PrivilegeInfo[] privilegeInfoArray = this.getSystemPrivileges(new Object[]{object});
        return privilegeInfoArray[0];
    }

    public RoleData[][] getRolesInfo(Object[] objectArray) {
        RoleData[] roleDataArray;
        Collection<RoleTypes.Info> collection;
        RoleData[][] roleDataArrayArray;
        block5: {
            roleDataArrayArray = new RoleData[objectArray.length][];
            Object object = objectArray[0];
            collection = null;
            try {
                roleDataArray = this._authzMgr.getSolutionService(object);
                collection = this.getRolesSecurely(object, (AuthorizationService)roleDataArray);
            }
            catch (Unauthorized unauthorized) {
                if (!_logger.isDebugEnabled()) break block5;
                _logger.debug((Object)("No privilege to get the role list for object: " + object), (Throwable)unauthorized);
            }
        }
        if (collection == null) {
            collection = new ArrayList<RoleTypes.Info>(0);
        }
        roleDataArray = new RoleData[collection.size()];
        int n = 0;
        for (RoleTypes.Info info : collection) {
            RoleData roleData = this.createRoleData(info);
            roleDataArray[n++] = roleData;
        }
        for (int i = 0; i < roleDataArrayArray.length; ++i) {
            roleDataArrayArray[i] = roleDataArray;
        }
        return roleDataArrayArray;
    }

    private RoleData createRoleData(RoleTypes.Info info) {
        RoleData roleData = new RoleData();
        roleData.id = info.getId();
        roleData.name = info.getName();
        roleData.system = info.getSystem();
        roleData.privilegeIds = info.getPrivilegeId().toArray(new String[info.getPrivilegeId().size()]);
        roleData.system = info.getSystem();
        roleData.summary = AuthorizationUtil.getRoleLocalizedDescription((String)info.getDescription());
        roleData.label = AuthorizationUtil.getRoleLocalizedName((String)info.getName());
        roleData.tenant = info.getTenant();
        return roleData;
    }

    public RoleData[] getRolesInfo(Object object) {
        RoleData[][] roleDataArray = this.getRolesInfo(new Object[]{object});
        return roleDataArray[0];
    }

    public PermissionInfo[][] getEntityPermission(Object[] objectArray) {
        PermissionInfo[][] permissionInfoArrayArray = new PermissionInfo[objectArray.length][];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            AuthorizationService authorizationService = this._authzMgr.getService(object);
            AuthorizationService authorizationService2 = this._authzMgr.getSolutionService(object);
            DynamicID dynamicID = authorizationService.getReferenceId(object);
            try {
                Permission permission = authorizationService.getPermissionManger();
                PermissionTypes.QuerySpec querySpec = new PermissionTypes.QuerySpec();
                querySpec.setResourceId(dynamicID);
                querySpec.setInheritance(true);
                List list = permission.queryDetail(querySpec);
                ArrayList<PermissionInfo> arrayList = new ArrayList<PermissionInfo>(list.size());
                for (PermissionTypes.Info info : list) {
                    PermissionInfo permissionInfo = this.getPermissionInfo(info, authorizationService2);
                    arrayList.add(permissionInfo);
                }
                permissionInfoArrayArray[i] = (PermissionInfo[])ArrayUtil.toArray(arrayList, PermissionInfo.class);
                continue;
            }
            catch (Unauthorized unauthorized) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("No privilege to get permission list for: " + dynamicID), (Throwable)unauthorized);
                }
                permissionInfoArrayArray[i] = new PermissionInfo[0];
            }
        }
        return permissionInfoArrayArray;
    }

    public PermissionInfo[] getEntityPermission(Object object) {
        PermissionInfo[][] permissionInfoArray = this.getEntityPermission(new Object[]{object});
        return permissionInfoArray[0];
    }

    public Boolean[] getHasPrivileges(Object[] objectArray, String[] stringArray) {
        Boolean[] booleanArray = this._privilegeCache.get(objectArray, stringArray);
        if (booleanArray != null) {
            return booleanArray;
        }
        this.checkServerGuids(objectArray);
        List<String> list = Arrays.asList(stringArray);
        AuthorizationService authorizationService = this._authzMgr.getService(objectArray[0]);
        List<Boolean> list2 = this.hasPrivilegeInternal(objectArray, list, authorizationService);
        Boolean[] booleanArray2 = list2.toArray(new Boolean[objectArray.length]);
        this._privilegeCache.put(objectArray, stringArray, booleanArray2);
        return booleanArray2;
    }

    public boolean getHasPrivileges(Object object, String[] stringArray) {
        Boolean[] booleanArray = this.getHasPrivileges(new Object[]{object}, stringArray);
        return booleanArray[0];
    }

    private static Set<String> extractProperties(PropertySpec[] propertySpecArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertySpec propertySpec : (PropertySpec[])ArrayUtil.toSafe((Object[])propertySpecArray, PropertySpec.class)) {
            hashSet.addAll(Arrays.asList(propertySpec.propertyNames));
        }
        return hashSet;
    }

    private boolean hasViewPrivilege(Object object, AuthorizationService authorizationService) {
        boolean bl = false;
        String string = SsoUtil.getUser();
        Set set = SsoUtil.getGroups();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("System.View");
        DynamicID dynamicID = authorizationService.getReferenceId(object);
        PrivilegeTypes.QuerySpec querySpec = new PrivilegeTypes.QuerySpec();
        querySpec.setResourceId(dynamicID);
        querySpec.setUserName(string);
        querySpec.setGroupName(new ArrayList(set));
        bl = authorizationService.getPrivilegeManager().hasPrivileges(querySpec, new ArrayList(hashSet));
        return bl;
    }

    private Collection<RoleTypes.Info> getRolesSecurely(Object object, AuthorizationService authorizationService) {
        ArrayList<RoleTypes.Info> arrayList = null;
        if (this.hasViewPrivilege(object, authorizationService)) {
            Role role = authorizationService.getRoleManager();
            List list = role.list();
            arrayList = new ArrayList<RoleTypes.Info>(list.size());
            for (String string : list) {
                RoleTypes.Info info = role.get(string);
                arrayList.add(info);
            }
        } else {
            _logger.debug((Object)("No System.View privilege to get the role list for " + object));
        }
        return arrayList != null ? arrayList : new ArrayList<RoleTypes.Info>();
    }

    private Collection<String> getPrivilegesSecurely(Object object, AuthorizationService authorizationService) {
        ArrayList<String> arrayList = (ArrayList<String>)SessionUtil.getData((String)PRIVILEGES_CACHE_KEY);
        if (arrayList != null) {
            return arrayList;
        }
        if (this.hasViewPrivilege(object, authorizationService)) {
            Privilege privilege = authorizationService.getPrivilegeManager();
            arrayList = privilege.list();
        } else {
            _logger.debug((Object)("No System.View privilege to get the system privilege list for " + object));
        }
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        SessionUtil.setData((String)PRIVILEGES_CACHE_KEY, (Object)arrayList);
        return arrayList;
    }

    private List<Boolean> hasPrivilegeInternal(Object[] batchQuerySpec, List<String> list, AuthorizationService authorizationService) {
        String string = SsoUtil.getUser();
        Set set = SsoUtil.getGroups();
        LinkedList<DynamicID> linkedList = new LinkedList<DynamicID>();
        for (Object object : batchQuerySpec) {
            linkedList.add(authorizationService.getReferenceId(object));
        }
        PrivilegeTypes.BatchQuerySpec batchQuerySpec2 = new PrivilegeTypes.BatchQuerySpec();
        batchQuerySpec2.setResourceId(linkedList);
        batchQuerySpec2.setUserName(string);
        batchQuerySpec2.setGroupName(new ArrayList(set));
        Privilege privilege = authorizationService.getPrivilegeManager();
        List<Object> list2 = new ArrayList(((PrivilegeTypes.BatchQuerySpec)batchQuerySpec).length);
        try {
            list2 = privilege.batchHasPrivileges(batchQuerySpec2, list);
        }
        catch (Unauthorized unauthorized) {
            _logger.warn((Object)"Not enough privileges to check own privileges.", (Throwable)unauthorized);
            list2 = this.fallbackHasPrivileges((Object[])batchQuerySpec, list, authorizationService);
        }
        return list2;
    }

    private List<Boolean> fallbackHasPrivileges(Object[] objectArray, List<String> list, AuthorizationService authorizationService) {
        _logger.info((Object)"Fallback to unbatched permission checking mode");
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(objectArray.length);
        String string = SsoUtil.getUser();
        Set set = SsoUtil.getGroups();
        Privilege privilege = authorizationService.getPrivilegeManager();
        for (Object object : objectArray) {
            DynamicID dynamicID = authorizationService.getReferenceId(object);
            PrivilegeTypes.QuerySpec querySpec = new PrivilegeTypes.QuerySpec();
            querySpec.setResourceId(dynamicID);
            querySpec.setUserName(string);
            querySpec.setGroupName(new ArrayList(set));
            try {
                arrayList.add(privilege.hasPrivileges(querySpec, list));
            }
            catch (Unauthorized unauthorized) {
                _logger.debug((Object)"Not enough privileges to check own privileges.", (Throwable)unauthorized);
                arrayList.add(false);
            }
        }
        return arrayList;
    }

    private PermissionInfo getPermissionInfo(PermissionTypes.Info info, AuthorizationService authorizationService) {
        PermissionInfo permissionInfo = new PermissionInfo();
        PermissionData permissionData = VCAuthorizationUtil.toPermissionData(info, authorizationService);
        try {
            if (permissionData.roleId != null) {
                RoleTypes.Info info2 = this.getRole(permissionData.roleId, authorizationService);
                permissionInfo.label = AuthorizationUtil.getRoleLocalizedName((String)info2.getName());
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)"Failed to retrieve role information:", (Throwable)exception);
        }
        permissionInfo.permission = permissionData;
        return permissionInfo;
    }

    private RoleTypes.Info getRole(String string, AuthorizationService authorizationService) throws AuthorizationClientException {
        String string2 = AUTHZ_ROLE_CACHE_KEY_PREFIX + String.valueOf(authorizationService.hashCode()) + ":" + string;
        RoleTypes.Info info = (RoleTypes.Info)SessionUtil.getData((String)string2);
        if (info != null) {
            return info;
        }
        info = authorizationService.getRoleManager().get(string);
        SessionUtil.setExpirableData((String)string2, (Object)info, (int)5000);
        return info;
    }
}

