/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vcservice;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.vcservice.CompatibilityException;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroupCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroupCompatibilityResult;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityResult;
import com.vmware.vise.vim.vcservice.CompatibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExtensionServiceAwareVcCompatibilityChecker
implements VcServiceCompatibilityChecker,
LinkedVcGroupCompatibilityChecker {
    private final ExtensionService _extensionService;
    private volatile LazyState _state;

    public ExtensionServiceAwareVcCompatibilityChecker(@Nonnull ExtensionService extensionService) {
        Preconditions.checkArgument((extensionService != null ? 1 : 0) != 0, (Object)"extensionService is null");
        this._extensionService = extensionService;
    }

    public LinkedVcGroupCompatibilityResult verify(@Nonnull LinkedVcGroup linkedVcGroup) {
        Preconditions.checkArgument((linkedVcGroup != null ? 1 : 0) != 0, (Object)"linkedVcGroup is null");
        LazyState lazyState = this.getState();
        if (lazyState.clientPackage == null) {
            return LinkedVcGroupCompatibilityResult.createCompatibleResult((LinkedVcGroup)linkedVcGroup);
        }
        Collection collection = linkedVcGroup.getVcServices();
        ArrayList<VcServiceCompatibilityResult> arrayList = null;
        for (VcService vcService : collection) {
            VcServiceCompatibilityResult vcServiceCompatibilityResult = this.doVerifyVcService(lazyState, vcService);
            if (vcServiceCompatibilityResult.isCompatible()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<VcServiceCompatibilityResult>(3);
            }
            arrayList.add(vcServiceCompatibilityResult);
        }
        if (arrayList != null) {
            VcService vcService;
            LinkedVcGroupCompatibilityResult.LinkedVcGroupCompatibilityFailure linkedVcGroupCompatibilityFailure = arrayList.size() == collection.size() ? LinkedVcGroupCompatibilityResult.LinkedVcGroupCompatibilityFailure.ALL_VCS_UNSUPPORTED : LinkedVcGroupCompatibilityResult.LinkedVcGroupCompatibilityFailure.SOME_UNSUPPORTED_VCS;
            vcService = LinkedVcGroupCompatibilityResult.createIncompatibleResult((LinkedVcGroup)linkedVcGroup, (LinkedVcGroupCompatibilityResult.LinkedVcGroupCompatibilityFailure)linkedVcGroupCompatibilityFailure, (Collection)arrayList, (String)lazyState.vSphereClientVersion);
            return vcService;
        }
        return LinkedVcGroupCompatibilityResult.createCompatibleResult((LinkedVcGroup)linkedVcGroup);
    }

    @Nonnull
    public VcServiceCompatibilityResult verify(@Nonnull VcService vcService) throws CompatibilityException {
        Preconditions.checkArgument((vcService != null ? 1 : 0) != 0, (Object)"vcService is null");
        LazyState lazyState = this.getState();
        return this.doVerifyVcService(lazyState, vcService);
    }

    @Nonnull
    private VcServiceCompatibilityResult doVerifyVcService(@Nonnull LazyState lazyState, @Nonnull VcService vcService) {
        if (lazyState.clientPackage == null) {
            return VcServiceCompatibilityResult.createCompatibleResult((VcService)vcService);
        }
        if (lazyState.supportedVcVersions == null || lazyState.supportedVcVersions.length == 0) {
            return VcServiceCompatibilityResult.createIncompatibleResult((VcService)vcService, (VcServiceCompatibilityResult.VcServiceCompatibilityFailure)VcServiceCompatibilityResult.VcServiceCompatibilityFailure.SUPPORTED_VERSIONS_MISSING, (String)lazyState.vSphereClientVersion);
        }
        AboutInfo aboutInfo = vcService.getServiceInstanceContent().about;
        if (VcServiceUtil.isEsxServer((AboutInfo)aboutInfo)) {
            return VcServiceCompatibilityResult.createIncompatibleResult((VcService)vcService, (VcServiceCompatibilityResult.VcServiceCompatibilityFailure)VcServiceCompatibilityResult.VcServiceCompatibilityFailure.ESX_HOSTS_ARE_NOT_SUPPORTED, (String)lazyState.vSphereClientVersion);
        }
        String string = vcService.getServiceVersion();
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = aboutInfo.version;
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return VcServiceCompatibilityResult.createIncompatibleResult((VcService)vcService, (VcServiceCompatibilityResult.VcServiceCompatibilityFailure)VcServiceCompatibilityResult.VcServiceCompatibilityFailure.VERSION_NOT_AVAILABLE, (String)lazyState.vSphereClientVersion);
        }
        boolean bl = Version.isSupportedVersion((String[])lazyState.supportedVcVersions, (String)string);
        if (!bl) {
            VcServiceCompatibilityResult vcServiceCompatibilityResult = VcServiceCompatibilityResult.createIncompatibleResult((VcService)vcService, (VcServiceCompatibilityResult.VcServiceCompatibilityFailure)VcServiceCompatibilityResult.VcServiceCompatibilityFailure.UNSUPPORTED_VERSION, (String)lazyState.vSphereClientVersion);
            return vcServiceCompatibilityResult;
        }
        return VcServiceCompatibilityResult.createCompatibleResult((VcService)vcService);
    }

    @Nonnull
    private LazyState getState() {
        LazyState lazyState = this._state;
        if (lazyState != null && lazyState.clientPackage != null) {
            return lazyState;
        }
        lazyState = new LazyState();
        PluginPackageInfo pluginPackageInfo = CompatibilityUtil.getPluginPackageInfo(this._extensionService);
        if (pluginPackageInfo != null) {
            lazyState.clientPackage = pluginPackageInfo;
            LazyState.access$202(lazyState, CompatibilityUtil.getSupportedServerVersions(pluginPackageInfo));
            lazyState.vSphereClientVersion = pluginPackageInfo != null ? pluginPackageInfo.getVersion() : null;
            this._state = lazyState;
        }
        return lazyState;
    }

    private static class LazyState {
        private PluginPackageInfo clientPackage;
        private String[] supportedVcVersions;
        private String vSphereClientVersion;

        private LazyState() {
        }

        static /* synthetic */ String[] access$202(LazyState lazyState, String[] stringArray) {
            lazyState.supportedVcVersions = stringArray;
            return stringArray;
        }
    }
}

