/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.data;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterHelper;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DataProviderAdapterBase
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(DataProviderAdapterBase.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getData(RequestSpec requestSpec) throws Exception {
        if (requestSpec == null) {
            throw new IllegalArgumentException("requestSpec is null");
        }
        if (requestSpec.querySpec == null) {
            throw new IllegalArgumentException("requestSpec.querySpec is null");
        }
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            QuerySpec querySpec = querySpecArray[i];
            assert (querySpec != null);
            try {
                resultSetArray[i] = this.getResult(querySpec.resourceSpec.constraint, querySpec);
                continue;
            }
            catch (RuntimeException runtimeException) {
                _logger.error((Object)("Unchecked exception processing query " + querySpec.name), (Throwable)runtimeException);
                throw runtimeException;
            }
            catch (Exception exception) {
                _logger.error((Object)("Checked exception processing query " + querySpec.name), (Throwable)exception);
                resultSetArray[i] = ResultUtil.newErrorResultSet((Exception[])new Exception[]{exception});
                continue;
            }
            finally {
                if (resultSetArray[i] != null) {
                    resultSetArray[i].queryName = querySpec.name;
                }
            }
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    private ResultSet getResult(Constraint constraint, QuerySpec querySpec) throws Exception {
        if (constraint == null) {
            _logger.error((Object)("Resource spec for query " + querySpec.name + " is unconstrained (null)"));
            return ResultUtil.newEmptyResultSet();
        }
        if (constraint instanceof CompositeConstraint) {
            return this.processQuery((CompositeConstraint)constraint, querySpec);
        }
        if (constraint instanceof RelationalConstraint) {
            return this.processQuery((RelationalConstraint)constraint, querySpec);
        }
        if (constraint instanceof PropertyConstraint) {
            return this.processQuery((PropertyConstraint)constraint, querySpec);
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            return this.processQuery((ObjectIdentityConstraint)constraint, querySpec);
        }
        if (constraint.getClass().equals(Constraint.class)) {
            return this.processQuery(constraint, querySpec);
        }
        _logger.warn((Object)("Unknown constraint type " + constraint.getClass().getName() + " is not handled"));
        return ResultUtil.newEmptyResultSet();
    }

    protected ResultSet processQuery(Constraint constraint, QuerySpec querySpec) throws Exception {
        assert (constraint != null && querySpec != null);
        return ResultUtil.newEmptyResultSet();
    }

    protected ResultSet processQuery(CompositeConstraint compositeConstraint, QuerySpec querySpec) throws Exception {
        assert (compositeConstraint != null && querySpec != null);
        return ResultUtil.newEmptyResultSet();
    }

    protected ResultSet processQuery(ObjectIdentityConstraint objectIdentityConstraint, QuerySpec querySpec) throws Exception {
        assert (objectIdentityConstraint != null && querySpec != null);
        return ResultUtil.newEmptyResultSet();
    }

    protected ResultSet processQuery(PropertyConstraint propertyConstraint, QuerySpec querySpec) throws Exception {
        assert (propertyConstraint != null && querySpec != null);
        return ResultUtil.newEmptyResultSet();
    }

    protected ResultSet processQuery(RelationalConstraint relationalConstraint, QuerySpec querySpec) throws Exception {
        assert (relationalConstraint != null && querySpec != null);
        return ResultUtil.newEmptyResultSet();
    }

    protected ResultSet getUnionOfSubConstraintResults(CompositeConstraint compositeConstraint, QuerySpec querySpec) {
        assert (compositeConstraint != null && querySpec != null);
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>(compositeConstraint.nestedConstraints.length);
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            try {
                ResultSet resultSet = this.getResult(constraint, querySpec);
                arrayList.add(resultSet);
            }
            catch (RuntimeException runtimeException) {
                _logger.error((Object)("Unchecked exception processing nested constraint of type " + constraint.getClass()), (Throwable)runtimeException);
                throw runtimeException;
            }
            catch (Exception exception) {
                _logger.error((Object)("Checked exception processing nested constraint of type " + constraint.getClass() + " in query " + querySpec.name), (Throwable)exception);
                arrayList.add(ResultUtil.newErrorResultSet((Exception[])new Exception[]{exception}));
            }
        }
        return DataProviderAdapterHelper.mergeResultSets(arrayList);
    }
}

