/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security.spring;

import com.vmware.vise.security.internal.SecurityUtil;
import com.vmware.vise.security.spring.RememberMeHandler;
import com.vmware.vise.security.spring.WebAuthenticationDetails;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.accessibility.AccessibilitySessionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.util.StringUtils;

public class DefaultRememberMeProvider
implements RememberMeServices,
LogoutHandler {
    public static final String SPRING_SECURITY_REMEMBER_ME_COOKIE_KEY = "SPRING_SECURITY_REMEMBER_ME_COOKIE";
    public static final String DEFAULT_PARAMETER = "_spring_security_remember_me";
    public static final int TOKEN_VALIDITY_SECONDS = 1209600;
    private static final String DELIMITER = ";";
    private volatile boolean _alwaysRemember = false;
    private volatile int _tokenValiditySeconds = 1209600;
    private static final Log _logger = LogFactory.getLog(DefaultRememberMeProvider.class);
    private final RememberMeHandler _rememberMeHandler;

    public DefaultRememberMeProvider() {
        this._rememberMeHandler = null;
    }

    public DefaultRememberMeProvider(RememberMeHandler rememberMeHandler) {
        this._rememberMeHandler = rememberMeHandler;
    }

    public RememberMeHandler getRememberMeHandler() {
        return this._rememberMeHandler;
    }

    public Authentication autoLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getParameter("sessionTicket");
        if (!StringUtil.isNullOrEmpty((String)string)) {
            return this.autoLoginUsingSessionTicket(string, httpServletRequest);
        }
        String string2 = this.extractRememberMeCookie(httpServletRequest);
        if (string2 == null) {
            return null;
        }
        try {
            long l;
            String[] stringArray = this.decodeCookie(string2);
            if (stringArray.length < 4) {
                String string3 = SecurityUtil.getLocalizedString("error.invalidNumberOfCookieTokens");
                throw new InvalidCookieException(string3);
            }
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            try {
                l = new Long(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                String string6 = SecurityUtil.getLocalizedString("error.invalidExpiryTimeCookieToken");
                throw new InvalidCookieException(string6);
            }
            if (this.isTokenExpired(l)) {
                String string7 = SecurityUtil.getLocalizedString("error.invalidExpiryTimeCookieToken");
                throw new InvalidCookieException(string7);
            }
            String string8 = stringArray[3];
            HttpSession httpSession = httpServletRequest.getSession();
            AccessibilitySessionUtil.setAccessibilityPref((HttpSession)httpSession, (Boolean)Boolean.parseBoolean(string8));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 4; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            WebAuthenticationDetails webAuthenticationDetails = null;
            webAuthenticationDetails = this._rememberMeHandler != null ? this._rememberMeHandler.getAuthenticationDetails(httpServletRequest, arrayList.toArray(new String[0])) : new WebAuthenticationDetails(httpServletRequest);
            this.markRequestAsRememberMe(webAuthenticationDetails);
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)string4, (Object)string5, (Collection)null);
            usernamePasswordAuthenticationToken.setDetails((Object)webAuthenticationDetails);
            return usernamePasswordAuthenticationToken;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error during autoLogin", (Throwable)exception);
            return null;
        }
    }

    public void loginFail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.cancelCookie(httpServletRequest, httpServletResponse);
    }

    public void loginSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
        if (!this.rememberMeRequested(httpServletRequest, DEFAULT_PARAMETER)) {
            return;
        }
        String string = this.retrieveUserName(authentication);
        String string2 = this.retrievePassword(authentication);
        WebAuthenticationDetails webAuthenticationDetails = (WebAuthenticationDetails)((Object)authentication.getDetails());
        if (!StringUtils.hasLength((String)string) || !StringUtils.hasLength((String)string2)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(string2);
        long l = System.currentTimeMillis() + 1209600000L;
        arrayList.add(Long.toString(l));
        HttpSession httpSession = httpServletRequest.getSession();
        Boolean bl = AccessibilitySessionUtil.getAccessibilityPref((HttpSession)httpSession);
        String string3 = bl != null ? bl.toString() : Boolean.FALSE.toString();
        arrayList.add(string3);
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = this._rememberMeHandler != null ? this._rememberMeHandler.getCookieTokens(httpServletRequest, webAuthenticationDetails) : new String[]{};
            if (stringArray != null) {
                for (String string4 : stringArray) {
                    arrayList.add(string4);
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when getting cookie tokens", (Throwable)exception);
        }
        this.setCookie(arrayList.toArray(new String[0]), this._tokenValiditySeconds, httpServletRequest, httpServletResponse);
    }

    public void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) {
        this.cancelCookie(httpServletRequest, httpServletResponse);
    }

    protected boolean rememberMeRequested(HttpServletRequest httpServletRequest, String string) {
        if (this._alwaysRemember) {
            return true;
        }
        String string2 = httpServletRequest.getParameter(string);
        return string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes") || string2.equals("1"));
    }

    protected void cancelCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie(SPRING_SECURITY_REMEMBER_ME_COOKIE_KEY, null);
        cookie.setMaxAge(0);
        cookie.setPath(StringUtils.hasLength((String)httpServletRequest.getContextPath()) ? httpServletRequest.getContextPath() : "/");
        httpServletResponse.addCookie(cookie);
    }

    private Authentication autoLoginUsingSessionTicket(String string, HttpServletRequest httpServletRequest) {
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)string, (Object)"", (Collection)null);
        WebAuthenticationDetails webAuthenticationDetails = new WebAuthenticationDetails(httpServletRequest);
        this.markRequestAsRememberMe(webAuthenticationDetails);
        usernamePasswordAuthenticationToken.setDetails((Object)webAuthenticationDetails);
        return usernamePasswordAuthenticationToken;
    }

    private void markRequestAsRememberMe(WebAuthenticationDetails webAuthenticationDetails) {
        Map<String, String> map = webAuthenticationDetails.getParameterMap();
        if (map == null) {
            map = new HashMap<String, String>();
            webAuthenticationDetails.setParameterMap(map);
        }
        map.put("_remember_me", Boolean.TRUE.toString());
    }

    private String extractRememberMeCookie(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null || cookieArray.length == 0) {
            return null;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!SPRING_SECURITY_REMEMBER_ME_COOKIE_KEY.equals(cookieArray[i].getName())) continue;
            return cookieArray[i].getValue();
        }
        return null;
    }

    protected void setCookie(String[] stringArray, int n, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = this.encodeCookie(stringArray);
        Cookie cookie = new Cookie(SPRING_SECURITY_REMEMBER_ME_COOKIE_KEY, string);
        cookie.setMaxAge(n);
        cookie.setPath(StringUtils.hasLength((String)httpServletRequest.getContextPath()) ? httpServletRequest.getContextPath() : "/");
        httpServletResponse.addCookie(cookie);
    }

    protected String retrieveUserName(Authentication authentication) {
        if (this.isInstanceOfUserDetails(authentication)) {
            return ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return authentication.getPrincipal().toString();
    }

    protected String retrievePassword(Authentication authentication) {
        if (this.isInstanceOfUserDetails(authentication)) {
            return ((UserDetails)authentication.getPrincipal()).getPassword();
        }
        return authentication.getCredentials().toString();
    }

    private boolean isInstanceOfUserDetails(Authentication authentication) {
        return authentication.getPrincipal() instanceof UserDetails;
    }

    protected boolean isTokenExpired(long l) {
        return l < System.currentTimeMillis();
    }

    protected String[] decodeCookie(String string) throws InvalidCookieException {
        for (int i = 0; i < string.length() % 4; ++i) {
            string = string + "=";
        }
        if (!Base64.isArrayByteBase64((byte[])string.getBytes())) {
            String string2 = SecurityUtil.getLocalizedString("error.invalidCookieEncoding");
            throw new InvalidCookieException(string2);
        }
        String string3 = new String(Base64.decodeBase64((byte[])string.getBytes()));
        return StringUtils.delimitedListToStringArray((String)string3, (String)DELIMITER);
    }

    protected String encodeCookie(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(DELIMITER);
        }
        String string = stringBuffer.toString();
        stringBuffer = new StringBuffer(new String(Base64.encodeBase64((byte[])string.getBytes())));
        while (stringBuffer.charAt(stringBuffer.length() - 1) == '=') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public void setAlwaysRemember(boolean bl) {
        this._alwaysRemember = bl;
    }

    public void setTokenValiditySeconds(int n) {
        this._tokenValiditySeconds = n;
    }
}

