/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.security.websso;

import com.vmware.vise.security.websso.SecurityRequestWrapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SecurityRequestWrapperFilter
extends OncePerRequestFilter {
    private static final Log _logger = LogFactory.getLog(SecurityRequestWrapperFilter.class);
    private final boolean _forceHttps;

    public SecurityRequestWrapperFilter(boolean bl) {
        this._forceHttps = bl;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string = httpServletRequest.getHeader("X-Forwarded-Proto");
        if (this._forceHttps || "https".equalsIgnoreCase(string) && !"https".equalsIgnoreCase(httpServletRequest.getScheme())) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"X-Forwarded-Proto set to https, so encapsulate it with secure request.");
            }
            SecurityRequestWrapper securityRequestWrapper = new SecurityRequestWrapper(httpServletRequest);
            filterChain.doFilter((ServletRequest)securityRequestWrapper, (ServletResponse)httpServletResponse);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

