/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.sso.impl;

import com.vmware.cis.common.sso.AdminHelper;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.GroupDetails;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.client.AdminClientFactory;
import com.vmware.vim.sso.admin.client.ClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientFactory;
import com.vmware.vim.sso.admin.exception.DuplicateSolutionCertificateException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class AdminHelperImpl
implements AdminHelper {
    static final Log _log = LogFactory.getLog(AdminHelperImpl.class);
    AdminClient _client;

    public AdminHelperImpl(SamlToken samlToken, PrivateKey hokKey, URI serverUri, KeyStore trustStore, String trustStorePassword, ThumbprintVerifier thumbprintVerifier) {
        VmomiClientConfiguration.Builder builder = new VmomiClientConfiguration.Builder(serverUri, VmomiClientConfiguration.Version.Version2);
        builder.setSslConfiguration(new VmomiClientConfiguration.SslConfiguration(thumbprintVerifier, trustStore, trustStorePassword));
        VmomiClientConfiguration config = builder.createConfig();
        AdminClientFactory factory = VmomiClientFactory.createAdminClientFactory((VmomiClientConfiguration)config);
        ClientConfiguration.AuthenticationData authData = null;
        if (samlToken != null) {
            authData = hokKey != null ? new ClientConfiguration.AuthenticationData(samlToken, hokKey) : new ClientConfiguration.AuthenticationData(samlToken);
        }
        ClientConfiguration clientConfig = authData != null ? new ClientConfiguration(authData) : new ClientConfiguration();
        this._client = factory.createAdminClient(clientConfig);
    }

    public AdminHelperImpl(URI serverUri, KeyStore trustStore, String trustStorePassword, ThumbprintVerifier thumbprintVerifier) {
        this(null, null, serverUri, trustStore, trustStorePassword, thumbprintVerifier);
    }

    @Override
    public List<X509Certificate> fetchTrustedCertificates() {
        return new ArrayList<X509Certificate>(this._client.getServerConfigurator().getTrustedCertificates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalId createSolutionUser(String name, String description, X509Certificate cert) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException, DuplicateSolutionCertificateException {
        PrincipalId principalId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("createSolutionUser: Entering (%s)", name));
        }
        PrincipalId id = null;
        try {
            SolutionDetails details = new SolutionDetails(cert, description);
            principalId = id = this._client.getPrincipalManagement().createLocalSolutionUser(name, details);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("createSolutionUser: Leaving (%s, %s)", name, id));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("createSolutionUser: Leaving (%s, %s)", name, id));
        }
        return principalId;
    }

    @Override
    public void deleteSolutionUser(String name) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("deleteSolutionUser: Entering (%s)", name));
        }
        try {
            this._client.getPrincipalManagement().deleteLocalPrincipal(name);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("deleteSolutionUser: Leaving (%s)", name));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("deleteSolutionUser: Leaving (%s)", name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalId createLocalGroup(String name, String description) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        PrincipalId principalId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("createLocalGroup: Entering (%s)", name));
        }
        PrincipalId id = null;
        try {
            principalId = id = this._client.getPrincipalManagement().createLocalGroup(name, new GroupDetails(description));
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("createLocalGroup: Leaving (%s, %s)", name, id));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("createLocalGroup: Leaving (%s, %s)", name, id));
        }
        return principalId;
    }

    @Override
    public void deleteLocalGroup(String name) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("deleteLocalGroup: Entering (%s)", name));
        }
        try {
            this._client.getPrincipalManagement().deleteLocalPrincipal(name);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("deleteLocalGroup: Leaving (%s)", name));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("deleteLocalGroup: Leaving (%s)", name));
        }
    }

    @Override
    public void addUserToLocalGroup(PrincipalId user, String group) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("addUserToLocalGroup: Entering (%s, %s)", user, group));
        }
        try {
            this._client.getPrincipalManagement().addUserToLocalGroup(user, group);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("addUserToLocalGroup: Leaving (%s, %s)", user, group));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("addUserToLocalGroup: Leaving (%s, %s)", user, group));
        }
    }

    @Override
    public void removeUserFromLocalGroup(PrincipalId user, String group) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("removeUserFromLocalGroup: Entering (%s, %s)", user, group));
        }
        try {
            this._client.getPrincipalManagement().removeFromLocalGroup(user, group);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("removeUserFromLocalGroup: Leaving (%s, %s)", user, group));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("removeUserFromLocalGroup: Leaving (%s, %s)", user, group));
        }
    }

    @Override
    public String getSystemDomainName() throws NotAuthenticatedException, NoPermissionException {
        String string;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"getSystemDomainName: Entering");
        }
        String systemDomain = null;
        try {
            string = systemDomain = this._client.getDomainManagement().getSystemDomainName();
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("getSystemDomainName: Leaving (%s)", systemDomain));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("getSystemDomainName: Leaving (%s)", systemDomain));
        }
        return string;
    }

    @Override
    public void dispose() {
        this._client.dispose();
    }

    public AdminClient getAdminClient() {
        return this._client;
    }
}

