/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.sso.impl;

import com.vmware.cis.common.sso.AdminClientUtil;
import com.vmware.cis.common.sso.ClientHelper;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientHelperImpl
implements ClientHelper {
    private static Log _log = LogFactory.getLog(ClientHelperImpl.class);
    private final URL _stsUrl;
    private final StsCertificates _stsCertificates;
    private ExecutorService _executorService = null;

    public ClientHelperImpl(URL adminUrl, URL stsUrl, KeyStore trustStore, char[] trustStorePassword, ThumbprintVerifier thumbprintVerifier) throws IOException, URISyntaxException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("ClientHelperImpl: Entering (adminUrl=%s, stsUrl=%s)", adminUrl, stsUrl));
        }
        this._stsUrl = stsUrl;
        if (trustStore == null) {
            trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, null);
        }
        CapturingVerifier capturingVerifier = new CapturingVerifier(thumbprintVerifier);
        AdminClient adminClient = AdminClientUtil.createAdminClientAnonymous(new URI(adminUrl.toString()), trustStore, trustStorePassword != null ? new String(trustStorePassword) : null, capturingVerifier);
        ArrayList signingCerts = new ArrayList(adminClient.getServerConfigurator().getIssuersCertificates());
        adminClient.dispose();
        this._stsCertificates = new StsCertificates(capturingVerifier._certificateChain, signingCerts.toArray(new X509Certificate[signingCerts.size()]), capturingVerifier._sslThumbprint);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"ClientHelperImpl: Leaving");
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this._executorService = executorService;
    }

    public ClientHelperImpl(URL stsUrl, X509Certificate[] stsSslCertificates, X509Certificate[] signingCerts) throws IOException, URISyntaxException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("ClientHelperImpl: Entering (stsUrl=%s)", stsUrl));
        }
        this._stsUrl = stsUrl;
        this._stsCertificates = new StsCertificates(stsSslCertificates, signingCerts, null);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"ClientHelperImpl: Leaving");
        }
    }

    public X509Certificate[] getCertificateChain() {
        return this._stsCertificates.getSslCertificates();
    }

    private static TokenSpec createTokenSpec(long tokenLifetimeSecs, String[] audienceRestrictions) {
        return ClientHelperImpl.createTokenSpec(tokenLifetimeSecs, audienceRestrictions, (String)null);
    }

    private static TokenSpec createTokenSpec(long tokenLifetimeSecs, String[] audienceRestrictions, String delegateTo) {
        return ClientHelperImpl.createTokenSpec(tokenLifetimeSecs, audienceRestrictions, new TokenSpec.DelegationSpec(true, delegateTo));
    }

    private static TokenSpec createTokenSpec(long tokenLifetimeSecs, String[] audienceRestrictions, TokenSpec.DelegationSpec delegationSpec) {
        TokenSpec.Builder builder = new TokenSpec.Builder(tokenLifetimeSecs);
        builder.delegationSpec(delegationSpec);
        if (audienceRestrictions != null) {
            HashSet<String> restrictions = new HashSet<String>();
            restrictions.addAll(Arrays.asList(audienceRestrictions));
            builder.audienceRestriction(restrictions);
        }
        return builder.createTokenSpec();
    }

    @Override
    public SamlToken acquireHolderOfKeyToken(String userName, char[] password, X509Certificate certificate, Key privateKey, String[] audienceRestrictions, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireHolderOfKeyToken(userName, new String(password), certificate, privateKey, audienceRestrictions, tokenLifetimeSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireHolderOfKeyToken(String userName, String password, X509Certificate certificate, Key privateKey, String[] audienceRestrictions, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        SamlToken samlToken;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireHolderOfKeyToken: Entering (%s)", userName));
        }
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(this._stsUrl, this._stsCertificates.getSslCertificates(), this._stsCertificates.getSslThumbprint());
        SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig(privateKey, certificate, null);
        SecurityTokenServiceConfig stsConfig = new SecurityTokenServiceConfig(connConfig, this._stsCertificates.getSigningCertificates(), this._executorService, hokConfig);
        SecurityTokenService stsClient = DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)stsConfig);
        TokenSpec tokenSpec = ClientHelperImpl.createTokenSpec(tokenLifetimeSecs, audienceRestrictions);
        SamlToken token = null;
        try {
            samlToken = token = stsClient.acquireToken(userName, password, tokenSpec);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("acquireHolderOfKeyToken: Leaving (%s, succeeded=%b)", userName, token != null));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireHolderOfKeyToken: Leaving (%s, succeeded=%b)", userName, token != null));
        }
        return samlToken;
    }

    @Override
    public SamlToken acquireBearerToken(String userName, char[] password, String[] audienceRestrictions, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireBearerToken(userName, new String(password), audienceRestrictions, tokenLifetimeSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireBearerToken(String userName, String password, String[] audienceRestrictions, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        SamlToken samlToken;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireBearerToken: Entering (%s)", userName));
        }
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(this._stsUrl, this._stsCertificates.getSslCertificates(), this._stsCertificates.getSslThumbprint());
        SecurityTokenServiceConfig stsConfig = new SecurityTokenServiceConfig(connConfig, this._stsCertificates.getSigningCertificates(), this._executorService);
        SecurityTokenService stsClient = DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)stsConfig);
        TokenSpec tokenSpec = ClientHelperImpl.createTokenSpec(tokenLifetimeSecs, audienceRestrictions);
        SamlToken token = null;
        try {
            samlToken = token = stsClient.acquireToken(userName, password, tokenSpec);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("acquireBearerToken: Leaving (%s, succeeded=%b)", userName, token != null));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireBearerToken: Leaving (%s, succeeded=%b)", userName, token != null));
        }
        return samlToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireTokenByCertificate(X509Certificate certificate, Key privateKey, String[] audienceRestrictions, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        SamlToken samlToken;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireTokenByCertificate: Entering (%s)", certificate.getSubjectDN()));
        }
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(this._stsUrl, this._stsCertificates.getSslCertificates(), this._stsCertificates.getSslThumbprint());
        SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig(privateKey, certificate, null);
        SecurityTokenServiceConfig stsConfig = new SecurityTokenServiceConfig(connConfig, this._stsCertificates.getSigningCertificates(), this._executorService, hokConfig);
        SecurityTokenService stsClient = DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)stsConfig);
        TokenSpec tokenSpec = ClientHelperImpl.createTokenSpec(tokenLifetimeSecs, audienceRestrictions);
        SamlToken token = null;
        try {
            samlToken = token = stsClient.acquireTokenByCertificate(tokenSpec);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("acquireTokenByCertificate: Leaving (%s, succeeded=%b)", certificate.getSubjectDN(), token != null));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireTokenByCertificate: Leaving (%s, succeeded=%b)", certificate.getSubjectDN(), token != null));
        }
        return samlToken;
    }

    @Override
    public SamlToken acquireHolderOfKeyToken(String userName, char[] password, X509Certificate certificate, Key privateKey, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireHolderOfKeyToken(userName, password, certificate, privateKey, null, tokenLifetimeSecs);
    }

    @Override
    public SamlToken acquireHolderOfKeyToken(String userName, String password, X509Certificate certificate, Key privateKey, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireHolderOfKeyToken(userName, password, certificate, privateKey, null, tokenLifetimeSecs);
    }

    @Override
    public SamlToken acquireBearerToken(String userName, char[] password, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireBearerToken(userName, password, null, tokenLifetimeSecs);
    }

    @Override
    public SamlToken acquireBearerToken(String userName, String password, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireBearerToken(userName, password, null, tokenLifetimeSecs);
    }

    @Override
    public SamlToken acquireTokenByCertificate(X509Certificate certificate, Key privateKey, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        return this.acquireTokenByCertificate(certificate, privateKey, null, tokenLifetimeSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireDelegatedToken(SamlToken token, String delegateTo, X509Certificate certificate, Key privateKey, String[] audienceRestrictions, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        SamlToken samlToken;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireDelegatedToken: Entering (delegate=%s)", delegateTo));
        }
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(this._stsUrl, this._stsCertificates.getSslCertificates(), this._stsCertificates.getSslThumbprint());
        SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig(privateKey, certificate, null);
        SecurityTokenServiceConfig stsConfig = new SecurityTokenServiceConfig(connConfig, this._stsCertificates.getSigningCertificates(), this._executorService, hokConfig);
        SecurityTokenService stsClient = DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)stsConfig);
        TokenSpec tokenSpec = ClientHelperImpl.createTokenSpec(tokenLifetimeSecs, audienceRestrictions, delegateTo);
        SamlToken delegatedToken = null;
        try {
            samlToken = delegatedToken = stsClient.acquireTokenByToken(token, tokenSpec);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("acquireDelegatedToken: Leaving (succeeded=%b)", delegatedToken != null));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireDelegatedToken: Leaving (succeeded=%b)", delegatedToken != null));
        }
        return samlToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SamlToken acquireActAsToken(SamlToken actAsToken, X509Certificate certificate, Key privateKey, String[] audienceRestrictions, long tokenLifetimeSecs) throws InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        SamlToken samlToken;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireActAsToken: Entering (actas=%s)", actAsToken == null ? "null" : actAsToken.getSubjectNameId()));
        }
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(this._stsUrl, this._stsCertificates.getSslCertificates(), this._stsCertificates.getSslThumbprint());
        SecurityTokenServiceConfig.HolderOfKeyConfig hokConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig(privateKey, certificate, null);
        SecurityTokenServiceConfig stsConfig = new SecurityTokenServiceConfig(connConfig, this._stsCertificates.getSigningCertificates(), this._executorService, hokConfig);
        SecurityTokenService stsClient = DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)stsConfig);
        TokenSpec tokenSpec = ClientHelperImpl.createTokenSpec(tokenLifetimeSecs, audienceRestrictions, new TokenSpec.DelegationSpec(actAsToken, true));
        SamlToken newToken = null;
        try {
            samlToken = newToken = stsClient.acquireTokenByCertificate(tokenSpec);
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("acquireActAsToken: Leaving (succeeded=%b)", newToken != null));
            }
            throw throwable;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("acquireActAsToken: Leaving (succeeded=%b)", newToken != null));
        }
        return samlToken;
    }

    static class CapturingVerifier
    implements ThumbprintVerifier {
        private static Log _log = LogFactory.getLog(CapturingVerifier.class);
        String _sslThumbprint = null;
        X509Certificate[] _certificateChain;
        ThumbprintVerifier _wrappedVerifier;

        public CapturingVerifier(ThumbprintVerifier verifier) {
            this._wrappedVerifier = verifier;
        }

        public ThumbprintVerifier.Result verify(String thumbprint) {
            ThumbprintVerifier.Result result;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("verify: Entering (%s)", thumbprint));
            }
            ThumbprintVerifier.Result result2 = result = this._wrappedVerifier != null ? this._wrappedVerifier.verify(thumbprint) : ThumbprintVerifier.Result.MISMATCH;
            if (result == ThumbprintVerifier.Result.MATCH) {
                this._sslThumbprint = thumbprint;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("verify: Leaving (%s, %s)", thumbprint, result));
            }
            return result;
        }

        public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)String.format("onSuccess: Received SSO SSL certificate chain with %d entries", chain.length));
            }
            this._certificateChain = new X509Certificate[chain.length];
            System.arraycopy(chain, 0, this._certificateChain, 0, chain.length);
            if (this._wrappedVerifier != null) {
                this._wrappedVerifier.onSuccess(chain, thumbprint, verifyResult, trustedChain, verifiedAssertions);
            }
        }
    }

    static class StsCertificates {
        X509Certificate[] _sslCertificates;
        X509Certificate[] _signingCertificates;
        String _sslThumbprint;

        X509Certificate[] getSslCertificates() {
            return this._sslCertificates != null ? this._sslCertificates : new X509Certificate[]{};
        }

        X509Certificate[] getSigningCertificates() {
            return this._signingCertificates != null ? this._signingCertificates : new X509Certificate[]{};
        }

        String getSslThumbprint() {
            return this._sslThumbprint;
        }

        StsCertificates(X509Certificate[] sslCertificates, X509Certificate[] signingCertificates, String thumbprint) throws NoSuchAlgorithmException, CertificateEncodingException {
            this._sslCertificates = sslCertificates;
            this._signingCertificates = signingCertificates;
            this._sslThumbprint = thumbprint != null ? thumbprint : SslUtil.computeCertificateThumbprint((X509Certificate)this._sslCertificates[0]);
        }
    }
}

