/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.common.util.impl;

import com.vmware.cis.common.util.impl.DiskSpaceCheckImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskSpaceCheckLog {
    private static final long DEFAULT_DELAY_S = 1800L;
    private static final Log _log = LogFactory.getLog(DiskSpaceCheckLog.class);
    private final ScheduledExecutorService _ses;
    private List<String> _files;
    private long _outDelay = 1800L;

    public DiskSpaceCheckLog() {
        final ThreadGroup tg = new ThreadGroup("DiskSpaceCheckLog");
        ThreadFactory t = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(tg, r);
                t.setDaemon(true);
                return t;
            }
        };
        this._ses = Executors.newScheduledThreadPool(1, t);
    }

    public void setFiles(List<String> files) {
        this._files = files;
    }

    public void setDelaySeconds(long delay) {
        this._outDelay = delay;
    }

    public void init() {
        new LogDump().call();
    }

    public void destroy() {
        this._ses.shutdown();
    }

    class LogDump
    implements Callable<Void> {
        LogDump() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            DiskSpaceCheckImpl dsci = new DiskSpaceCheckImpl();
            Float dsup = Float.valueOf(-1.0f);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
            Date now = new Date();
            try {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("==== Disk Space Check at [" + dateFormat.format(now) + "] ==== \n" + "FileName : DiskSpaceUsedPercentage"));
                    for (String file : DiskSpaceCheckLog.this._files) {
                        dsup = Float.valueOf(dsci.getUsedPercentage(file));
                        _log.info((Object)String.format("[%s : %3.2f]", file, dsup));
                    }
                }
                Iterator iterator = null;
                return iterator;
            }
            catch (Exception e) {
                if (_log.isErrorEnabled()) {
                    _log.error((Object)"Failed to check space", (Throwable)e);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                DiskSpaceCheckLog.this._ses.schedule(this, DiskSpaceCheckLog.this._outDelay, TimeUnit.SECONDS);
            }
        }
    }
}

