/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.util;

import com.google.common.base.Charsets;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vsphere.client.security.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.HttpRequestHandler;

public class InterSiteTransferServlet
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(InterSiteTransferServlet.class);
    private final LookupService _lookupService;
    private static final String APP_ID = "appId";

    public InterSiteTransferServlet(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        HttpSession httpSession = httpServletRequest.getSession();
        SamlToken samlToken = AuthSessionUtil.getSsoToken((HttpSession)httpSession);
        if (samlToken == null) {
            throw new ServletException(Util.getLocalizedString("InterSiteTransferServlet.notAuthenticated", new String[0]));
        }
        String string = samlToken.toXml();
        byte[] byArray = Base64.encodeBase64((byte[])string.getBytes(Charsets.UTF_8));
        String string2 = new String(byArray, Charsets.UTF_8);
        ServerInfo serverInfo = this.getRedirectServerInfo(httpServletRequest);
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setHeader("Pragma", "no-cache");
        this.respondWithHtmlForm(httpServletResponse, string2, serverInfo);
    }

    private ServerInfo getRedirectServerInfo(HttpServletRequest httpServletRequest) throws ServletException {
        String string = httpServletRequest.getParameter(APP_ID);
        if (!StringUtil.isNullOrEmpty((String)string)) {
            return this.getService(string);
        }
        throw new ServletException(Util.getLocalizedString("InterSiteTransferServlet.noUrl", new String[0]));
    }

    private ServerInfo getService(String string) throws ServletException {
        ServiceRegistration.Info info = null;
        try {
            info = this._lookupService.find(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when searching service - " + LogUtil.sanitize((String)string)), (Throwable)exception);
            throw new ServletException((Throwable)exception);
        }
        if (info == null) {
            String string2 = String.format(Util.getLocalizedString("InterSiteTransferServlet.noService", new String[0]), LogUtil.sanitize((String)string));
            throw new ServletException(string2);
        }
        if (info.getServiceEndpoints() == null || info.getServiceEndpoints().length == 0) {
            String string3 = String.format(Util.getLocalizedString("InterSiteTransferServlet.noEndpoint", new String[0]), LogUtil.sanitize((String)string));
            throw new ServletException(string3);
        }
        ServiceRegistration.Endpoint endpoint = info.getServiceEndpoints()[0];
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.serviceUrl = endpoint.getUrl().toString();
        serverInfo.name = info.getServiceNameResourceKey();
        return serverInfo;
    }

    private void respondWithHtmlForm(HttpServletResponse httpServletResponse, String string, ServerInfo serverInfo) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head></head>");
        printWriter.println("<body>");
        printWriter.println("<script type=\"text/javascript\">");
        printWriter.println("window.onload = function() { document.forms[0].submit(); }");
        printWriter.println("</script>");
        printWriter.println("<form method=\"post\" action=\"" + serverInfo.serviceUrl + "\">");
        printWriter.println("<input type=\"hidden\" name=\"SAMLResponse\" value=\"" + string + "\" />");
        printWriter.println("<div><b>Logging into " + serverInfo.name + "...</b></div>");
        printWriter.println("</form>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }
}

