/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.google.common.base.Preconditions;
import com.vmware.identity.websso.client.LogoutProcessor;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.vise.security.spring.DefaultAuthenticationProvider;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.security.util.Util;
import com.vmware.vsphere.client.security.websso.MetadataGenerator;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LogoutProcessorImpl
implements LogoutProcessor {
    private static final Log _logger = LogFactory.getLog(LogoutProcessorImpl.class);
    private final MetadataGenerator _metadataGenerator;
    private final DefaultAuthenticationProvider _authProvider;
    private String _targetUrl;
    private final boolean _webSsoNotificationsEnabled;

    @Autowired
    public LogoutProcessorImpl(@Nonnull ConfigurationService configurationService, @Nonnull MetadataGenerator metadataGenerator, @Nonnull DefaultAuthenticationProvider defaultAuthenticationProvider) {
        Preconditions.checkArgument((configurationService != null ? 1 : 0) != 0, (Object)"configService is null");
        Preconditions.checkArgument((metadataGenerator != null ? 1 : 0) != 0, (Object)"metadataGenerator is null");
        Preconditions.checkArgument((defaultAuthenticationProvider != null ? 1 : 0) != 0, (Object)"authProvider is null");
        this._metadataGenerator = metadataGenerator;
        this._authProvider = defaultAuthenticationProvider;
        String string = configurationService.getProperty("websso.handleLogoutNotifications");
        this._webSsoNotificationsEnabled = StringUtil.parseBoolean((String)string, (boolean)false);
    }

    public String getTargetUrl() {
        return this._targetUrl;
    }

    public void setTargetUrl(String string) {
        this._targetUrl = string;
    }

    public void logoutError(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = null;
        if (message == null || message.getValidationResult() == null) {
            string = Util.getLocalizedString("websso.unknownError", new String[0]);
            this.handleError(httpServletResponse, string);
            return;
        }
        WebssoUtil.logMessageDetails(message, "logoutError");
        ValidationResult validationResult = message.getValidationResult();
        if (validationResult.getResponseCode() == 200) {
            string = String.format(Util.getLocalizedString("websso.messageServerError", new String[0]), message.getStatus(), message.getSubstatus());
            _logger.error((Object)string);
            _logger.info((Object)"Websso session was already invalidated, either due to timeout or logout from other service. Initiate logout from NGC as well.");
            this.logoutSuccess(message, httpServletRequest, httpServletResponse);
            return;
        }
        if (WebssoUtil.handleSpecialValidationCases(validationResult, httpServletRequest, _logger)) {
            return;
        }
        string = String.format(Util.getLocalizedString("websso.messageDetail", new String[0]), validationResult.getResponseCode(), validationResult.getStatus(), validationResult.getSubstatus());
        _logger.error((Object)string);
        this.handleError(httpServletResponse, string);
    }

    public void logoutRequest(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        if (!this._webSsoNotificationsEnabled) {
            return;
        }
        _logger.info((Object)("Processing WebSSO logout notification for tenant: " + string));
        String string2 = message.getSessionIndex();
        if (StringUtil.isNullOrWhitespace((String)string2)) {
            _logger.error((Object)"Missing clientId. Aborting the processing of the notification");
            return;
        }
        DummyHttpSession dummyHttpSession = null;
        try {
            dummyHttpSession = new DummyHttpSession(httpServletRequest);
            SessionUtil.associateSessionWithClientId((HttpSession)dummyHttpSession, (String)string2);
            this._authProvider.logout((HttpSession)dummyHttpSession);
        }
        catch (Exception exception) {
            String string3 = null;
            if (dummyHttpSession != null) {
                string3 = SessionUtil.getHashedClientId((String)string2);
            }
            _logger.error((Object)("Failed to create a dummy session to handle a WebSSO logout notification" + (string3 != null ? " for clientId " + string3 : "") + ". Will not log out."), (Throwable)exception);
            return;
        }
    }

    public void logoutSuccess(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String string = !StringUtil.isNullOrEmpty((String)this._targetUrl) ? this._targetUrl : "/ngc_spring_security_logout";
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string);
            if (requestDispatcher != null) {
                _logger.info((Object)("Websso logout handshake done, forwarding to " + string));
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                String string2 = this._metadataGenerator.getSloUri();
                String string3 = message.getTarget().replace(string2, string);
                _logger.info((Object)("Websso logout handshake done, redirecting to " + string3));
                httpServletResponse.sendRedirect(string3);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when processing the success websso logout message", (Throwable)exception);
            this.handleError(httpServletResponse, exception.getMessage());
        }
    }

    public void internalError(Exception exception, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        _logger.error((Object)"An internal error occurred when processing response for websso logout.", (Throwable)exception);
        this.handleError(httpServletResponse, exception.getMessage(), 500);
    }

    private void handleError(HttpServletResponse httpServletResponse, String string) {
        this.handleError(httpServletResponse, string, 400);
    }

    private void handleError(HttpServletResponse httpServletResponse, String string, int n) {
        try {
            String string2 = String.format(Util.getLocalizedString("websso.logoutError", new String[0]), string);
            httpServletResponse.sendError(n, string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class DummyServletContext
    implements ServletContext {
        private final String _contextPath;

        DummyServletContext(String string) {
            this._contextPath = string;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public ServletContext getContext(String string) {
            throw new UnsupportedOperationException();
        }

        public int getMajorVersion() {
            throw new UnsupportedOperationException();
        }

        public int getMinorVersion() {
            throw new UnsupportedOperationException();
        }

        public int getEffectiveMajorVersion() {
            throw new UnsupportedOperationException();
        }

        public int getEffectiveMinorVersion() {
            throw new UnsupportedOperationException();
        }

        public String getMimeType(String string) {
            throw new UnsupportedOperationException();
        }

        public Set<String> getResourcePaths(String string) {
            throw new UnsupportedOperationException();
        }

        public URL getResource(String string) throws MalformedURLException {
            throw new UnsupportedOperationException();
        }

        public InputStream getResourceAsStream(String string) {
            throw new UnsupportedOperationException();
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            throw new UnsupportedOperationException();
        }

        public RequestDispatcher getNamedDispatcher(String string) {
            throw new UnsupportedOperationException();
        }

        public Servlet getServlet(String string) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public Enumeration<Servlet> getServlets() {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getServletNames() {
            throw new UnsupportedOperationException();
        }

        public void log(String string) {
            throw new UnsupportedOperationException();
        }

        public void log(Exception exception, String string) {
            throw new UnsupportedOperationException();
        }

        public void log(String string, Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        public String getRealPath(String string) {
            throw new UnsupportedOperationException();
        }

        public String getServerInfo() {
            throw new UnsupportedOperationException();
        }

        public String getInitParameter(String string) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getInitParameterNames() {
            throw new UnsupportedOperationException();
        }

        public boolean setInitParameter(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String string) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getAttributeNames() {
            throw new UnsupportedOperationException();
        }

        public void setAttribute(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String string) {
            throw new UnsupportedOperationException();
        }

        public String getServletContextName() {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
            throw new UnsupportedOperationException();
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration getServletRegistration(String string) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
            throw new UnsupportedOperationException();
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration getFilterRegistration(String string) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            throw new UnsupportedOperationException();
        }

        public SessionCookieConfig getSessionCookieConfig() {
            throw new UnsupportedOperationException();
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
            throw new UnsupportedOperationException();
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            throw new UnsupportedOperationException();
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            throw new UnsupportedOperationException();
        }

        public void addListener(String string) {
            throw new UnsupportedOperationException();
        }

        public <T extends EventListener> void addListener(T t) {
            throw new UnsupportedOperationException();
        }

        public void addListener(Class<? extends EventListener> clazz) {
            throw new UnsupportedOperationException();
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getClassLoader() {
            throw new UnsupportedOperationException();
        }

        public void declareRoles(String ... stringArray) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DummyHttpSession
    implements HttpSession {
        private static final AtomicLong SESSION_ID_GENERATOR = new AtomicLong(0L);
        private final ConcurrentMap<String, Object> _attributes = new ConcurrentHashMap<String, Object>();
        private final String _id = "dummy-session-id-" + SESSION_ID_GENERATOR.incrementAndGet();
        private final ServletContext _servletContext;

        public DummyHttpSession(HttpServletRequest httpServletRequest) {
            String string = httpServletRequest.getRequestURI();
            this._servletContext = new DummyServletContext(string);
        }

        public String getId() {
            return this._id;
        }

        public Object getAttribute(String string) {
            Object v = this._attributes.get(string);
            return v;
        }

        public void setAttribute(String string, Object object) {
            if (object == null) {
                this._attributes.remove(string);
            } else {
                this._attributes.put(string, object);
            }
        }

        public void removeAttribute(String string) {
            this._attributes.remove(string);
        }

        public Enumeration<String> getAttributeNames() {
            Set set = this._attributes.keySet();
            final Iterator iterator = set.iterator();
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }

        public ServletContext getServletContext() {
            return this._servletContext;
        }

        public void invalidate() {
            throw new UnsupportedOperationException();
        }

        public long getCreationTime() {
            throw new UnsupportedOperationException();
        }

        public long getLastAccessedTime() {
            throw new UnsupportedOperationException();
        }

        public void setMaxInactiveInterval(int n) {
            throw new UnsupportedOperationException();
        }

        public int getMaxInactiveInterval() {
            throw new UnsupportedOperationException();
        }

        public HttpSessionContext getSessionContext() {
            throw new UnsupportedOperationException();
        }

        public Object getValue(String string) {
            throw new UnsupportedOperationException();
        }

        public String[] getValueNames() {
            throw new UnsupportedOperationException();
        }

        public void putValue(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        public void removeValue(String string) {
            throw new UnsupportedOperationException();
        }

        public boolean isNew() {
            throw new UnsupportedOperationException();
        }
    }
}

