/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.vmware.identity.websso.client.AssertionConsumerService;
import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.SingleLogoutService;
import com.vmware.identity.websso.client.SingleSignOnService;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.net.ssl.SSLConfigurationProviderBuilder;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vsphere.client.security.util.Util;
import com.vmware.vsphere.client.security.websso.MetadataGenerator;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetadataGeneratorImpl
implements MetadataGenerator {
    private static final Log _logger = LogFactory.getLog(MetadataGeneratorImpl.class);
    private static final String METADATA_QUERY_PARAM = "metadataReset=true";
    private final MetadataSettings _metadataSettings;
    private final SsoService _ssoService;
    @Nullable
    private final SsoServiceManager _ssoServiceManager;
    @Nullable
    private final SsoConfigurationProvider _ssoConfigurationProvider;
    @Nullable
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final boolean _forceHttps;
    private final String _ssoUri;
    private final String _sloUri;
    private volatile SsoAdminService _ssoAdminService;
    private volatile SsoSolutionUser _ngcSolutionUser;

    public MetadataGeneratorImpl(@Nonnull MetadataSettings metadataSettings, @Nonnull SsoService ssoService, @Nonnull SsoServiceManager ssoServiceManager, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull SSLConfigurationProvider sSLConfigurationProvider) {
        this(metadataSettings, ssoService, ssoServiceManager, ssoConfigurationProvider, sSLConfigurationProvider, true, "/saml/websso/sso", "/saml/websso/slo");
    }

    public MetadataGeneratorImpl(@Nonnull MetadataSettings metadataSettings, @Nonnull SsoService ssoService, @Nonnull SsoServiceManager ssoServiceManager, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull SSLConfigurationProvider sSLConfigurationProvider, boolean bl, @Nonnull String string, @Nonnull String string2) {
        this(true, (MetadataSettings)ValidationUtil.notNull((Object)metadataSettings, (String)"metadataSettings is null"), (SsoService)ValidationUtil.notNull((Object)ssoService, (String)"ssoService is null"), (SsoServiceManager)ValidationUtil.notNull((Object)ssoServiceManager, (String)"ssoServiceManager is null"), (SsoConfigurationProvider)ValidationUtil.notNull((Object)ssoConfigurationProvider, (String)"ssoConfigurationProvider is null"), (SSLConfigurationProvider)ValidationUtil.notNull((Object)sSLConfigurationProvider, (String)"sslConfigurationProvider is null"), bl, (String)ValidationUtil.notNull((Object)string, (String)"ssoUri is null"), (String)ValidationUtil.notNull((Object)string2, (String)"sloUri is null"));
    }

    private MetadataGeneratorImpl(boolean bl, MetadataSettings metadataSettings, SsoService ssoService, SsoServiceManager ssoServiceManager, SsoConfigurationProvider ssoConfigurationProvider, SSLConfigurationProvider sSLConfigurationProvider, boolean bl2, String string, String string2) {
        this._metadataSettings = metadataSettings;
        this._ssoService = ssoService;
        this._ssoServiceManager = ssoServiceManager;
        this._ssoConfigurationProvider = ssoConfigurationProvider;
        this._sslConfigurationProvider = sSLConfigurationProvider != null ? sSLConfigurationProvider : new SSLConfigurationProviderBuilder().build();
        this._forceHttps = bl2;
        this._ssoUri = string;
        this._sloUri = string2;
        this._ngcSolutionUser = SsoUtil.getSolutionUser();
    }

    @Override
    public String getSsoUri() {
        return this._ssoUri;
    }

    @Override
    public String getSloUri() {
        return this._sloUri;
    }

    @Override
    public void processMetadata(ServletRequest servletRequest) throws IOException, ServletException {
        try {
            _logger.info((Object)"Processing WebSSO metadata");
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            if (this.isMetadataCleanupRequired(httpServletRequest)) {
                _logger.info((Object)"Clearing websso metadata.");
                this._metadataSettings.clear();
            }
            this.getIDPConfiguration();
            String string = WebssoUtil.getSPAlias(httpServletRequest);
            String string2 = this.getSPUrl(httpServletRequest);
            this.getSPConfiguration(string, string2);
            _logger.info((Object)"Processed WebSSO metadata");
        }
        catch (Throwable throwable) {
            _logger.error((Object)"Failed to process WebSSO metadata", throwable);
            String string = String.format(Util.getLocalizedString("websso.metadataError", new String[0]), throwable.getMessage());
            throw new ServletException(string);
        }
    }

    @Override
    public void clearMetadata() {
        _logger.info((Object)"Clearing websso metadata.");
        this._metadataSettings.clear();
    }

    private boolean isMetadataCleanupRequired(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getQueryString();
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        return string.contains(METADATA_QUERY_PARAM);
    }

    private synchronized SsoAdminService getSsoAdminService() throws Exception {
        SsoAdminService ssoAdminService = this._ssoAdminService;
        if (ssoAdminService != null) {
            return ssoAdminService;
        }
        this._ssoAdminService = ssoAdminService = this._ssoServiceManager.getSolutionAdminService(null);
        return ssoAdminService;
    }

    private synchronized IDPConfiguration getIDPConfiguration() throws Exception {
        IDPConfiguration iDPConfiguration = this._metadataSettings.getIDPConfiguration("csp_ngc");
        if (iDPConfiguration == null) {
            iDPConfiguration = this.createIDPConfiguration();
        }
        return iDPConfiguration;
    }

    private synchronized SPConfiguration getSPConfiguration(String string, String string2) throws Exception {
        SPConfiguration sPConfiguration = this._metadataSettings.getSPConfiguration(string);
        if (sPConfiguration == null) {
            sPConfiguration = this.createSPConfiguration(string, string2);
        }
        return sPConfiguration;
    }

    private IDPConfiguration createIDPConfiguration() throws Exception {
        IDPConfiguration iDPConfiguration = null;
        try {
            int n;
            _logger.info((Object)"Creating an IDP configuration");
            SsoServerInfo ssoServerInfo = this._ssoService.getServerInfo();
            String string = ssoServerInfo.getMetadataUrl();
            HttpClient httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(ssoServerInfo.getKeyStore()).buildHttpClientIgnoreErrors();
            String string2 = httpClient.executeMethod(string, null, null);
            iDPConfiguration = WebssoUtil.getIDPConfigurationFromMetadata("csp_ngc", string2);
            if (this._ssoConfigurationProvider != null) {
                n = (int)this._ssoConfigurationProvider.getClockToleranceInSeconds();
            } else {
                SsoAdminService ssoAdminService = this.getSsoAdminService();
                ConfigurationManagementService configurationManagementService = ssoAdminService.getConfigurationManagementService();
                long l = configurationManagementService.getClockTolerance();
                n = (int)TimeUnit.MILLISECONDS.toSeconds(l);
            }
            iDPConfiguration.setClockTolerance(n);
            this._metadataSettings.addIDPConfiguration(iDPConfiguration);
            _logger.info((Object)("Added an IDP configuration to the metadata. All configs: " + MetadataGeneratorImpl.buildIDPConfigurationsDesc(this._metadataSettings.getAllIDPConfigurations())));
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when creating IDP metadata.", (Throwable)exception);
            throw exception;
        }
        return iDPConfiguration;
    }

    @Nullable
    private static String buildIDPConfigurationsDesc(Collection<IDPConfiguration> collection) {
        if (collection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(200).append('[');
        for (IDPConfiguration iDPConfiguration : collection) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("alias='").append(iDPConfiguration.getAlias()).append("', entityID='").append(iDPConfiguration.getEntityID()).append("', clockTolerance=").append(iDPConfiguration.getClockTolerance()).append(", singleSignOnServices=").append(MetadataGeneratorImpl.buildSingleSignOnServicesDesc(iDPConfiguration.getSingleSignOnServices())).append(", singleLogoutServices=").append(MetadataGeneratorImpl.buildSingleLogoutServicesDesc(iDPConfiguration.getSingleLogoutServices()));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String buildSingleSignOnServicesDesc(List<SingleSignOnService> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(70).append('[');
        for (SingleSignOnService singleSignOnService : list) {
            if (singleSignOnService == null) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(singleSignOnService.getLocation());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String buildSingleLogoutServicesDesc(List<SingleLogoutService> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(70).append('[');
        for (SingleLogoutService singleLogoutService : list) {
            if (singleLogoutService == null) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(singleLogoutService.getLocation());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private SPConfiguration createSPConfiguration(String string, String string2) throws Exception {
        SPConfiguration sPConfiguration = null;
        try {
            PrivateKey privateKey = this._ngcSolutionUser.getPrivateKey();
            X509Certificate x509Certificate = this._ngcSolutionUser.getCertificate();
            sPConfiguration = WebssoUtil.createDefaultSPConfiguration(string, string2, x509Certificate, privateKey, this._ssoUri, this._sloUri);
            String string3 = WebssoUtil.getMetadataFromSPConfiguration(sPConfiguration);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("SP Metadata XML:\n" + string3));
            }
            ConfigurationManagementService configurationManagementService = this.getSsoAdminService().getConfigurationManagementService();
            configurationManagementService.importSAMLMetadata(string3);
            this._metadataSettings.addSPConfiguration(sPConfiguration);
            _logger.info((Object)("Added an SP configuration to the metadata. All configs: " + MetadataGeneratorImpl.buildSPConfigurationsDesc(this._metadataSettings.getAllSPConfigurations())));
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when registering ngc metadata.", (Throwable)exception);
            throw exception;
        }
        return sPConfiguration;
    }

    @Nullable
    private static String buildSPConfigurationsDesc(Collection<SPConfiguration> collection) {
        if (collection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(200).append('[');
        for (SPConfiguration sPConfiguration : collection) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("alias='").append(sPConfiguration.getAlias()).append("', entityID='").append(sPConfiguration.getEntityID()).append("', assertionConsumerServices=").append(MetadataGeneratorImpl.buildAssertionConsumerServicesDesc(sPConfiguration.getAssertionConsumerServices())).append(", singleLogoutServices=").append(MetadataGeneratorImpl.buildSingleLogoutServicesDesc(sPConfiguration.getSingleLogoutServices()));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String buildAssertionConsumerServicesDesc(List<AssertionConsumerService> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(70).append('[');
        for (AssertionConsumerService assertionConsumerService : list) {
            if (assertionConsumerService == null) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(assertionConsumerService.getLocation());
            if (!assertionConsumerService.isDefault()) continue;
            stringBuilder.append(" (default)");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private String getSPUrl(HttpServletRequest httpServletRequest) {
        String string = this._forceHttps ? "https" : httpServletRequest.getScheme();
        String string2 = httpServletRequest.getServerName();
        int n = httpServletRequest.getServerPort();
        String string3 = httpServletRequest.getContextPath();
        String string4 = null;
        string4 = n > 0 && n != 80 && n != 443 ? string + "://" + string2 + ":" + n + string3 : string + "://" + string2 + string3;
        _logger.info((Object)("SP url generated is " + string4));
        return string4;
    }

    @Override
    public String getEntityId(ServletRequest servletRequest) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = WebssoUtil.getSPAlias(httpServletRequest);
        String string2 = this.getSPUrl(httpServletRequest);
        SPConfiguration sPConfiguration = this.getSPConfiguration(string, string2);
        return sPConfiguration.getEntityID();
    }
}

