/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt;

import com.vmware.af.VmAfClient;
import com.vmware.sso.tokenmgmt.SsoDomainFinder;
import com.vmware.vise.util.Optional;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SsoDomain {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    static final String PROP_NAME__LOCAL_DOMAIN_ID = "sso.localDomainId";
    static final String PROP_NAME__LOCAL_DOMAIN_NAME = "sso.localDomainName";
    static final String UNKNOWN_DOMAIN_NAME = "<unknown_domain_name>";
    static final String UNKNOWN_LOCAL_DOMAIN_ID = "<LDID>";
    static final String UNKNOWN_LOCAL_DOMAIN_NAME = "<unknown-local-domain-name>";
    private static volatile ServiceRegistry _serviceRegistry;
    private static volatile ConfigurationServiceData _configServiceData;
    @Nonnull
    private final String _id;
    @Nullable
    private final String _name;
    private final boolean _isLocal;
    private volatile String _cachedToString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private static SsoDomainFinder.SsoDomainData findLocalSsoDomain(@Nullable ServiceRegistry serviceRegistry) throws InterruptedException {
        if (serviceRegistry == null) {
            return null;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        SsoDomainFinderListener ssoDomainFinderListener = new SsoDomainFinderListener(atomicReference, countDownLatch);
        try {
            SsoDomainFinder.SsoDomainData ssoDomainData;
            serviceRegistry.registerServiceListener(SsoDomainFinder.class.getName(), (ServiceListener)ssoDomainFinderListener);
            countDownLatch.await(10L, TimeUnit.MINUTES);
            SsoDomainFinder.SsoDomainData ssoDomainData2 = ssoDomainData = (SsoDomainFinder.SsoDomainData)atomicReference.get();
            return ssoDomainData2;
        }
        finally {
            serviceRegistry.unregisterServiceListener(SsoDomainFinder.class.getName(), (ServiceListener)ssoDomainFinderListener);
        }
    }

    public static SsoDomain getLocal() {
        return HolderOfLocalSsoDomain.LOCAL;
    }

    static void setDependencies(@Nonnull ConfigurationService configurationService, @Nullable ServiceRegistry serviceRegistry) {
        String string;
        String string2;
        Validate.notNull((Object)configurationService);
        _serviceRegistry = serviceRegistry;
        Boolean bl = PropertyUtil.getBooleanProperty((ConfigurationService)configurationService, (String)"afd.disabled", (boolean)false);
        if (bl == null) {
            bl = false;
        }
        if (StringUtil.isNullOrWhitespace((String)(string2 = configurationService.getProperty(PROP_NAME__LOCAL_DOMAIN_ID)))) {
            string2 = null;
        }
        if (StringUtil.isNullOrWhitespace((String)(string = configurationService.getProperty(PROP_NAME__LOCAL_DOMAIN_NAME)))) {
            string = null;
        }
        _configServiceData = new ConfigurationServiceData(bl == false, string2, string);
    }

    private SsoDomain(@Nonnull String string, @Nullable String string2, boolean bl) {
        Validate.notEmpty((String)string);
        this._id = string;
        this._name = string2;
        this._isLocal = bl;
    }

    public static SsoDomain valueOf(@Nonnull String string, @Nullable String string2) {
        Validate.notNull((Object)string);
        SsoDomain ssoDomain = SsoDomain.getLocal();
        if (ssoDomain.getId().equals(string)) {
            return ssoDomain;
        }
        return new SsoDomain(string, string2, false);
    }

    public String getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public boolean isLocal() {
        return this._isLocal;
    }

    public static boolean isLocalDomainId(String string) {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        return ssoDomain.getId().equals(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SsoDomain) {
            SsoDomain ssoDomain = (SsoDomain)object;
            return this._id.equals(ssoDomain._id);
        }
        return false;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public String toString() {
        String string = this._cachedToString;
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this._name != null) {
                stringBuilder.append(this._name).append('(');
            }
            stringBuilder.append(this._id);
            if (this._isLocal) {
                stringBuilder.append("@L");
            }
            if (this._name != null) {
                stringBuilder.append(')');
            }
            this._cachedToString = string = stringBuilder.toString();
        }
        return string;
    }

    private static class ConfigurationServiceData {
        final boolean isAfdEnabled;
        final String localDomainId;
        final String localDomainName;

        ConfigurationServiceData(boolean bl, @Nullable String string, @Nullable String string2) {
            this.isAfdEnabled = bl;
            this.localDomainId = string;
            this.localDomainName = string2;
        }
    }

    private static class SsoDomainFinderListener
    implements ServiceListener {
        private final AtomicReference<SsoDomainFinder.SsoDomainData> _ssoDomainDataRef;
        private final CountDownLatch _latch;

        SsoDomainFinderListener(AtomicReference<SsoDomainFinder.SsoDomainData> atomicReference, CountDownLatch countDownLatch) {
            this._ssoDomainDataRef = atomicReference;
            this._latch = countDownLatch;
        }

        public void serviceAdded(Object object) {
            if (this._latch.getCount() == 0L) {
                return;
            }
            try {
                SsoDomainFinder ssoDomainFinder = (SsoDomainFinder)object;
                Optional<SsoDomainFinder.SsoDomainData> optional = ssoDomainFinder.findLocalDomain();
                this._ssoDomainDataRef.set((SsoDomainFinder.SsoDomainData)optional.orElse(null));
                this._latch.countDown();
            }
            catch (Exception exception) {
                _logger.error((Object)"SsoDomainFinder listener failure", (Throwable)exception);
            }
        }

        public void serviceRemoved(Object object) {
        }
    }

    private static class HolderOfLocalSsoDomain {
        static final SsoDomain LOCAL;

        private HolderOfLocalSsoDomain() {
        }

        static {
            Object object;
            ConfigurationServiceData configurationServiceData = _configServiceData;
            if (configurationServiceData == null) {
                throw new ExceptionInInitializerError("Before accessing the local SSO domain, please, invoke method " + SsoDomain.class.getSimpleName() + ".setDependencies(...)");
            }
            String string = null;
            String string2 = null;
            if (configurationServiceData.isAfdEnabled) {
                try {
                    object = new VmAfClient("localhost");
                    string = object.getDomainID();
                    string2 = object.getDomainName();
                    _logger.info((Object)"Determined the local SSO domain through VMAFD");
                }
                catch (Throwable throwable) {
                    _logger.error((Object)"VMAFD error", throwable);
                    string = null;
                }
            }
            if (string == null) {
                string = configurationServiceData.localDomainId;
                String string3 = string2 = configurationServiceData.localDomainName != null ? configurationServiceData.localDomainName : SsoDomain.UNKNOWN_LOCAL_DOMAIN_NAME;
                if (string != null) {
                    _logger.info((Object)"Determined the local SSO domain through config service");
                } else {
                    try {
                        object = SsoDomain.findLocalSsoDomain(_serviceRegistry);
                        if (object != null) {
                            string = ((SsoDomainFinder.SsoDomainData)object).getId();
                            string2 = ((SsoDomainFinder.SsoDomainData)object).getName();
                            _logger.info((Object)"Determined the local SSO domain through finder");
                        } else {
                            string = SsoDomain.UNKNOWN_LOCAL_DOMAIN_ID;
                            _logger.info((Object)"Fell back to unknown local SSO domain");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new ExceptionInInitializerError(interruptedException);
                    }
                }
            }
            LOCAL = new SsoDomain(string, string2, true);
            _logger.info((Object)("Local SSO domain: " + LOCAL));
            _configServiceData = null;
        }
    }
}

