/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public class TokenAcquisitionResult {
    @Nonnull
    private final SsoDomain _ssoDomain;
    private final SamlToken _token;
    private final Throwable _error;

    public TokenAcquisitionResult(@Nonnull SsoDomain ssoDomain, @Nullable SamlToken samlToken, @Nullable Throwable throwable) {
        Validate.notNull((Object)ssoDomain);
        if (samlToken == null && throwable == null) {
            throw new IllegalArgumentException("Both token and error are null");
        }
        this._ssoDomain = ssoDomain;
        this._token = samlToken;
        this._error = throwable;
    }

    public SsoDomain getSsoDomain() {
        return this._ssoDomain;
    }

    public Optional<SamlToken> getToken() {
        return Optional.ofNullable((Object)this._token);
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable((Object)this._error);
    }
}

