/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sso.tokenmgmt.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenAcquisitionResult;
import com.vmware.sso.tokenmgmt.TokenException;
import com.vmware.sso.tokenmgmt.TokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public class SingleDomainTokenProvider
implements TokenProvider {
    private final SsoDomain _ssoDomain;
    private final SamlToken _token;

    public SingleDomainTokenProvider(@Nonnull SsoDomain ssoDomain, @Nonnull SamlToken samlToken) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)samlToken);
        this._ssoDomain = ssoDomain;
        this._token = samlToken;
    }

    @Override
    public SamlToken getTokenForSsoDomain(SsoDomain ssoDomain) throws TokenException {
        if (!ssoDomain.equals(this._ssoDomain)) {
            throw new IllegalArgumentException("Domain " + ssoDomain + " was requested, but the only token is for domain " + this._ssoDomain);
        }
        return this._token;
    }

    @Override
    public Collection<TokenAcquisitionResult> getAllTokens() {
        TokenAcquisitionResult tokenAcquisitionResult = new TokenAcquisitionResult(this._ssoDomain, this._token, null);
        return Collections.singleton(tokenAcquisitionResult);
    }
}

