/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content;

import com.vmware.content.LibraryDefinitions;
import com.vmware.content.LibraryModel;
import com.vmware.content.LibraryProvider;
import com.vmware.content.LibraryTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class LibraryApiInterface
extends ApiInterfaceSkeleton {
    private LibraryProvider impl;

    public LibraryApiInterface() {
        this((Class<? extends LibraryProvider>)null);
    }

    public LibraryApiInterface(Class<? extends LibraryProvider> implClass) {
        this((LibraryProvider)LibraryApiInterface.createImplInstance(implClass, (String)"com.vmware.content.impl.LibraryImpl", LibraryProvider.class));
    }

    public LibraryApiInterface(LibraryProvider impl) {
        super("com.vmware.content.library");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new FindApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(LibraryApiInterface.this.getIdentifier(), "update", LibraryDefinitions.__updateInput, LibraryDefinitions.__updateOutput, LibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LibraryDefinitions.__updateInput, LibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LibraryModel updateSpec = (LibraryModel)extr.valueForField("update_spec");
            LibraryApiInterface.this.impl.update(libraryId, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(LibraryApiInterface.this.getTypeConverter(), LibraryDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class FindApiMethod
    extends ApiMethodSkeleton {
        public FindApiMethod() {
            super(LibraryApiInterface.this.getIdentifier(), "find", LibraryDefinitions.__findInput, LibraryDefinitions.__findOutput, LibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LibraryDefinitions.__findInput, LibraryApiInterface.this.getTypeConverter());
            LibraryTypes.FindSpec spec = (LibraryTypes.FindSpec)extr.valueForField("spec");
            LibraryApiInterface.this.impl.find(spec, (AsyncContext<List<String>>)new AsyncContextImpl(LibraryApiInterface.this.getTypeConverter(), LibraryDefinitions.__findOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(LibraryApiInterface.this.getIdentifier(), "list", LibraryDefinitions.__listInput, LibraryDefinitions.__listOutput, LibraryApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            LibraryApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(LibraryApiInterface.this.getTypeConverter(), LibraryDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(LibraryApiInterface.this.getIdentifier(), "get", LibraryDefinitions.__getInput, LibraryDefinitions.__getOutput, LibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LibraryDefinitions.__getInput, LibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LibraryApiInterface.this.impl.get(libraryId, (AsyncContext<LibraryModel>)new AsyncContextImpl(LibraryApiInterface.this.getTypeConverter(), LibraryDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

