/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content;

import com.vmware.content.LibraryDefinitions;
import com.vmware.content.LibraryModel;
import com.vmware.content.LibrarySyncProvider;
import com.vmware.content.LibraryTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class LibrarySyncApiInterface
extends ApiInterfaceSkeleton {
    private LibrarySyncProvider impl;

    public LibrarySyncApiInterface() {
        this((Class<? extends LibrarySyncProvider>)null);
    }

    public LibrarySyncApiInterface(Class<? extends LibrarySyncProvider> implClass) {
        this((LibrarySyncProvider)LibrarySyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.impl.LibraryImpl", LibrarySyncProvider.class));
    }

    public LibrarySyncApiInterface(LibrarySyncProvider impl) {
        super("com.vmware.content.library");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new FindApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(LibrarySyncApiInterface.this.getIdentifier(), "update", LibraryDefinitions.__updateInput, LibraryDefinitions.__updateOutput, LibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LibraryDefinitions.__updateInput, LibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LibraryModel updateSpec = (LibraryModel)extr.valueForField("update_spec");
            try {
                LibrarySyncApiInterface.this.impl.update(libraryId, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class FindApiMethod
    extends ApiMethodSkeleton {
        public FindApiMethod() {
            super(LibrarySyncApiInterface.this.getIdentifier(), "find", LibraryDefinitions.__findInput, LibraryDefinitions.__findOutput, LibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LibraryDefinitions.__findInput, LibrarySyncApiInterface.this.getTypeConverter());
            LibraryTypes.FindSpec spec = (LibraryTypes.FindSpec)extr.valueForField("spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)LibrarySyncApiInterface.this.getTypeConverter().convertToVapi(LibrarySyncApiInterface.this.impl.find(spec, invocationContext), LibraryDefinitions.__findOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(LibrarySyncApiInterface.this.getIdentifier(), "list", LibraryDefinitions.__listInput, LibraryDefinitions.__listOutput, LibrarySyncApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)LibrarySyncApiInterface.this.getTypeConverter().convertToVapi(LibrarySyncApiInterface.this.impl.list(invocationContext), LibraryDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(LibrarySyncApiInterface.this.getIdentifier(), "get", LibraryDefinitions.__getInput, LibraryDefinitions.__getOutput, LibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LibraryDefinitions.__getInput, LibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)LibrarySyncApiInterface.this.getTypeConverter().convertToVapi((Object)LibrarySyncApiInterface.this.impl.get(libraryId, invocationContext), LibraryDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

