/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content;

import com.vmware.content.LibraryModel;
import com.vmware.content.LocalLibraryDefinitions;
import com.vmware.content.LocalLibraryProvider;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class LocalLibraryApiInterface
extends ApiInterfaceSkeleton {
    private LocalLibraryProvider impl;

    public LocalLibraryApiInterface() {
        this((Class<? extends LocalLibraryProvider>)null);
    }

    public LocalLibraryApiInterface(Class<? extends LocalLibraryProvider> implClass) {
        this((LocalLibraryProvider)LocalLibraryApiInterface.createImplInstance(implClass, (String)"com.vmware.content.impl.LocalLibraryImpl", LocalLibraryProvider.class));
    }

    public LocalLibraryApiInterface(LocalLibraryProvider impl) {
        super("com.vmware.content.local_library");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(LocalLibraryApiInterface.this.getIdentifier(), "update", LocalLibraryDefinitions.__updateInput, LocalLibraryDefinitions.__updateOutput, LocalLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceBusy;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.concurrentChange;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__updateInput, LocalLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LibraryModel updateSpec = (LibraryModel)extr.valueForField("update_spec");
            LocalLibraryApiInterface.this.impl.update(libraryId, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(LocalLibraryApiInterface.this.getTypeConverter(), LocalLibraryDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(LocalLibraryApiInterface.this.getIdentifier(), "list", LocalLibraryDefinitions.__listInput, LocalLibraryDefinitions.__listOutput, LocalLibraryApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            LocalLibraryApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(LocalLibraryApiInterface.this.getTypeConverter(), LocalLibraryDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(LocalLibraryApiInterface.this.getIdentifier(), "get", LocalLibraryDefinitions.__getInput, LocalLibraryDefinitions.__getOutput, LocalLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__getInput, LocalLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LocalLibraryApiInterface.this.impl.get(libraryId, (AsyncContext<LibraryModel>)new AsyncContextImpl(LocalLibraryApiInterface.this.getTypeConverter(), LocalLibraryDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(LocalLibraryApiInterface.this.getIdentifier(), "delete", LocalLibraryDefinitions.__deleteInput, LocalLibraryDefinitions.__deleteOutput, LocalLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__deleteInput, LocalLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LocalLibraryApiInterface.this.impl.delete(libraryId, (AsyncContext<Void>)new AsyncContextImpl(LocalLibraryApiInterface.this.getTypeConverter(), LocalLibraryDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(LocalLibraryApiInterface.this.getIdentifier(), "create", LocalLibraryDefinitions.__createInput, LocalLibraryDefinitions.__createOutput, LocalLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, LocalLibraryDefinitions.__createInput, LocalLibraryApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            LibraryModel createSpec = (LibraryModel)extr.valueForField("create_spec");
            LocalLibraryApiInterface.this.impl.create(clientToken, createSpec, (AsyncContext<String>)new AsyncContextImpl(LocalLibraryApiInterface.this.getTypeConverter(), LocalLibraryDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

