/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content;

import com.vmware.content.LibraryModel;
import com.vmware.content.SubscribedLibraryDefinitions;
import com.vmware.content.SubscribedLibraryProvider;
import com.vmware.content.SubscribedLibraryTypes;
import com.vmware.content.library.SubscriptionInfo;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class SubscribedLibraryApiInterface
extends ApiInterfaceSkeleton {
    private SubscribedLibraryProvider impl;

    public SubscribedLibraryApiInterface() {
        this((Class<? extends SubscribedLibraryProvider>)null);
    }

    public SubscribedLibraryApiInterface(Class<? extends SubscribedLibraryProvider> implClass) {
        this((SubscribedLibraryProvider)SubscribedLibraryApiInterface.createImplInstance(implClass, (String)"com.vmware.content.impl.SubscribedLibraryImpl", SubscribedLibraryProvider.class));
    }

    public SubscribedLibraryApiInterface(SubscribedLibraryProvider impl) {
        super("com.vmware.content.subscribed_library");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new EvictApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new SyncApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new ProbeApiMethod());
    }

    private class ProbeApiMethod
    extends ApiMethodSkeleton {
        public ProbeApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "probe", SubscribedLibraryDefinitions.__probeInput, SubscribedLibraryDefinitions.__probeOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__probeInput, SubscribedLibraryApiInterface.this.getTypeConverter());
            SubscriptionInfo subscriptionInfo = (SubscriptionInfo)extr.valueForField("subscription_info");
            SubscribedLibraryApiInterface.this.impl.probe(subscriptionInfo, (AsyncContext<SubscribedLibraryTypes.ProbeResult>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__probeOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "update", SubscribedLibraryDefinitions.__updateInput, SubscribedLibraryDefinitions.__updateOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceBusy;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.concurrentChange;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__updateInput, SubscribedLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LibraryModel updateSpec = (LibraryModel)extr.valueForField("update_spec");
            SubscribedLibraryApiInterface.this.impl.update(libraryId, updateSpec, (AsyncContext<Void>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__updateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class SyncApiMethod
    extends ApiMethodSkeleton {
        public SyncApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "sync", SubscribedLibraryDefinitions.__syncInput, SubscribedLibraryDefinitions.__syncOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__syncInput, SubscribedLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            SubscribedLibraryApiInterface.this.impl.sync(libraryId, (AsyncContext<Void>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__syncOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "list", SubscribedLibraryDefinitions.__listInput, SubscribedLibraryDefinitions.__listOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            SubscribedLibraryApiInterface.this.impl.list((AsyncContext<List<String>>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "get", SubscribedLibraryDefinitions.__getInput, SubscribedLibraryDefinitions.__getOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__getInput, SubscribedLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            SubscribedLibraryApiInterface.this.impl.get(libraryId, (AsyncContext<LibraryModel>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class EvictApiMethod
    extends ApiMethodSkeleton {
        public EvictApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "evict", SubscribedLibraryDefinitions.__evictInput, SubscribedLibraryDefinitions.__evictOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__evictInput, SubscribedLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            SubscribedLibraryApiInterface.this.impl.evict(libraryId, (AsyncContext<Void>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__evictOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "delete", SubscribedLibraryDefinitions.__deleteInput, SubscribedLibraryDefinitions.__deleteOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__deleteInput, SubscribedLibraryApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            SubscribedLibraryApiInterface.this.impl.delete(libraryId, (AsyncContext<Void>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(SubscribedLibraryApiInterface.this.getIdentifier(), "create", SubscribedLibraryDefinitions.__createInput, SubscribedLibraryDefinitions.__createOutput, SubscribedLibraryApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__createInput, SubscribedLibraryApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            LibraryModel createSpec = (LibraryModel)extr.valueForField("create_spec");
            SubscribedLibraryApiInterface.this.impl.create(clientToken, createSpec, (AsyncContext<String>)new AsyncContextImpl(SubscribedLibraryApiInterface.this.getTypeConverter(), SubscribedLibraryDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

