/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content;

import com.vmware.content.LibraryModel;
import com.vmware.content.SubscribedLibraryDefinitions;
import com.vmware.content.SubscribedLibrarySyncProvider;
import com.vmware.content.library.SubscriptionInfo;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class SubscribedLibrarySyncApiInterface
extends ApiInterfaceSkeleton {
    private SubscribedLibrarySyncProvider impl;

    public SubscribedLibrarySyncApiInterface() {
        this((Class<? extends SubscribedLibrarySyncProvider>)null);
    }

    public SubscribedLibrarySyncApiInterface(Class<? extends SubscribedLibrarySyncProvider> implClass) {
        this((SubscribedLibrarySyncProvider)SubscribedLibrarySyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.impl.SubscribedLibraryImpl", SubscribedLibrarySyncProvider.class));
    }

    public SubscribedLibrarySyncApiInterface(SubscribedLibrarySyncProvider impl) {
        super("com.vmware.content.subscribed_library");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new EvictApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new SyncApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new ProbeApiMethod());
    }

    private class ProbeApiMethod
    extends ApiMethodSkeleton {
        public ProbeApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "probe", SubscribedLibraryDefinitions.__probeInput, SubscribedLibraryDefinitions.__probeOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__probeInput, SubscribedLibrarySyncApiInterface.this.getTypeConverter());
            SubscriptionInfo subscriptionInfo = (SubscriptionInfo)extr.valueForField("subscription_info");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)SubscribedLibrarySyncApiInterface.this.getTypeConverter().convertToVapi((Object)SubscribedLibrarySyncApiInterface.this.impl.probe(subscriptionInfo, invocationContext), SubscribedLibraryDefinitions.__probeOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "update", SubscribedLibraryDefinitions.__updateInput, SubscribedLibraryDefinitions.__updateOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceBusy;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.concurrentChange;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__updateInput, SubscribedLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            LibraryModel updateSpec = (LibraryModel)extr.valueForField("update_spec");
            try {
                SubscribedLibrarySyncApiInterface.this.impl.update(libraryId, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class SyncApiMethod
    extends ApiMethodSkeleton {
        public SyncApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "sync", SubscribedLibraryDefinitions.__syncInput, SubscribedLibraryDefinitions.__syncOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__syncInput, SubscribedLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                SubscribedLibrarySyncApiInterface.this.impl.sync(libraryId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "list", SubscribedLibraryDefinitions.__listInput, SubscribedLibraryDefinitions.__listOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)SubscribedLibrarySyncApiInterface.this.getTypeConverter().convertToVapi(SubscribedLibrarySyncApiInterface.this.impl.list(invocationContext), SubscribedLibraryDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "get", SubscribedLibraryDefinitions.__getInput, SubscribedLibraryDefinitions.__getOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__getInput, SubscribedLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)SubscribedLibrarySyncApiInterface.this.getTypeConverter().convertToVapi((Object)SubscribedLibrarySyncApiInterface.this.impl.get(libraryId, invocationContext), SubscribedLibraryDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class EvictApiMethod
    extends ApiMethodSkeleton {
        public EvictApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "evict", SubscribedLibraryDefinitions.__evictInput, SubscribedLibraryDefinitions.__evictOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__evictInput, SubscribedLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                SubscribedLibrarySyncApiInterface.this.impl.evict(libraryId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "delete", SubscribedLibraryDefinitions.__deleteInput, SubscribedLibraryDefinitions.__deleteOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__deleteInput, SubscribedLibrarySyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                SubscribedLibrarySyncApiInterface.this.impl.delete(libraryId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(SubscribedLibrarySyncApiInterface.this.getIdentifier(), "create", SubscribedLibraryDefinitions.__createInput, SubscribedLibraryDefinitions.__createOutput, SubscribedLibrarySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedLibraryDefinitions.__createInput, SubscribedLibrarySyncApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            LibraryModel createSpec = (LibraryModel)extr.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)SubscribedLibrarySyncApiInterface.this.getTypeConverter().convertToVapi((Object)SubscribedLibrarySyncApiInterface.this.impl.create(clientToken, createSpec, invocationContext), SubscribedLibraryDefinitions.__createOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

