/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library;

import com.vmware.content.library.ItemDefinitions;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.ItemSyncProvider;
import com.vmware.content.library.ItemTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class ItemSyncApiInterface
extends ApiInterfaceSkeleton {
    private ItemSyncProvider impl;

    public ItemSyncApiInterface() {
        this((Class<? extends ItemSyncProvider>)null);
    }

    public ItemSyncApiInterface(Class<? extends ItemSyncProvider> implClass) {
        this((ItemSyncProvider)ItemSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.impl.ItemImpl", ItemSyncProvider.class));
    }

    public ItemSyncApiInterface(ItemSyncProvider impl) {
        super("com.vmware.content.library.item");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CopyApiMethod());
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new FindApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(ItemSyncApiInterface.this.getIdentifier(), "update", ItemDefinitions.__updateInput, ItemDefinitions.__updateOutput, ItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__updateInput, ItemSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            ItemModel updateSpec = (ItemModel)extr.valueForField("update_spec");
            try {
                ItemSyncApiInterface.this.impl.update(libraryItemId, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class FindApiMethod
    extends ApiMethodSkeleton {
        public FindApiMethod() {
            super(ItemSyncApiInterface.this.getIdentifier(), "find", ItemDefinitions.__findInput, ItemDefinitions.__findOutput, ItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__findInput, ItemSyncApiInterface.this.getTypeConverter());
            ItemTypes.FindSpec spec = (ItemTypes.FindSpec)extr.valueForField("spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)ItemSyncApiInterface.this.getTypeConverter().convertToVapi(ItemSyncApiInterface.this.impl.find(spec, invocationContext), ItemDefinitions.__findOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(ItemSyncApiInterface.this.getIdentifier(), "list", ItemDefinitions.__listInput, ItemDefinitions.__listOutput, ItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__listInput, ItemSyncApiInterface.this.getTypeConverter());
            String libraryId = (String)extr.valueForField("library_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)ItemSyncApiInterface.this.getTypeConverter().convertToVapi(ItemSyncApiInterface.this.impl.list(libraryId, invocationContext), ItemDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(ItemSyncApiInterface.this.getIdentifier(), "get", ItemDefinitions.__getInput, ItemDefinitions.__getOutput, ItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__getInput, ItemSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)ItemSyncApiInterface.this.getTypeConverter().convertToVapi((Object)ItemSyncApiInterface.this.impl.get(libraryItemId, invocationContext), ItemDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(ItemSyncApiInterface.this.getIdentifier(), "delete", ItemDefinitions.__deleteInput, ItemDefinitions.__deleteOutput, ItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__deleteInput, ItemSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            try {
                ItemSyncApiInterface.this.impl.delete(libraryItemId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(ItemSyncApiInterface.this.getIdentifier(), "create", ItemDefinitions.__createInput, ItemDefinitions.__createOutput, ItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__createInput, ItemSyncApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            ItemModel createSpec = (ItemModel)extr.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)ItemSyncApiInterface.this.getTypeConverter().convertToVapi((Object)ItemSyncApiInterface.this.impl.create(clientToken, createSpec, invocationContext), ItemDefinitions.__createOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CopyApiMethod
    extends ApiMethodSkeleton {
        public CopyApiMethod() {
            super(ItemSyncApiInterface.this.getIdentifier(), "copy", ItemDefinitions.__copyInput, ItemDefinitions.__copyOutput, ItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ItemDefinitions.__copyInput, ItemSyncApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            String sourceLibraryItemId = (String)extr.valueForField("source_library_item_id");
            ItemModel destinationCreateSpec = (ItemModel)extr.valueForField("destination_create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)ItemSyncApiInterface.this.getTypeConverter().convertToVapi((Object)ItemSyncApiInterface.this.impl.copy(clientToken, sourceLibraryItemId, destinationCreateSpec, invocationContext), ItemDefinitions.__copyOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

