/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library;

import com.vmware.content.library.SubscribedItemDefinitions;
import com.vmware.content.library.SubscribedItemSyncProvider;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class SubscribedItemSyncApiInterface
extends ApiInterfaceSkeleton {
    private SubscribedItemSyncProvider impl;

    public SubscribedItemSyncApiInterface() {
        this((Class<? extends SubscribedItemSyncProvider>)null);
    }

    public SubscribedItemSyncApiInterface(Class<? extends SubscribedItemSyncProvider> implClass) {
        this((SubscribedItemSyncProvider)SubscribedItemSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.impl.SubscribedItemImpl", SubscribedItemSyncProvider.class));
    }

    public SubscribedItemSyncApiInterface(SubscribedItemSyncProvider impl) {
        super("com.vmware.content.library.subscribed_item");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new EvictApiMethod());
        this.registerMethod((ApiMethod)new SyncApiMethod());
    }

    private class SyncApiMethod
    extends ApiMethodSkeleton {
        public SyncApiMethod() {
            super(SubscribedItemSyncApiInterface.this.getIdentifier(), "sync", SubscribedItemDefinitions.__syncInput, SubscribedItemDefinitions.__syncOutput, SubscribedItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedItemDefinitions.__syncInput, SubscribedItemSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            boolean forceSyncContent = (Boolean)extr.valueForField("force_sync_content");
            try {
                SubscribedItemSyncApiInterface.this.impl.sync(libraryItemId, forceSyncContent, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class EvictApiMethod
    extends ApiMethodSkeleton {
        public EvictApiMethod() {
            super(SubscribedItemSyncApiInterface.this.getIdentifier(), "evict", SubscribedItemDefinitions.__evictInput, SubscribedItemDefinitions.__evictOutput, SubscribedItemSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementConfiguration;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SubscribedItemDefinitions.__evictInput, SubscribedItemSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            try {
                SubscribedItemSyncApiInterface.this.impl.evict(libraryItemId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

