/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.DownloadSessionDefinitions;
import com.vmware.content.library.item.DownloadSessionModel;
import com.vmware.content.library.item.DownloadSessionProvider;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class DownloadSessionApiInterface
extends ApiInterfaceSkeleton {
    private DownloadSessionProvider impl;

    public DownloadSessionApiInterface() {
        this((Class<? extends DownloadSessionProvider>)null);
    }

    public DownloadSessionApiInterface(Class<? extends DownloadSessionProvider> implClass) {
        this((DownloadSessionProvider)DownloadSessionApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.DownloadSessionImpl", DownloadSessionProvider.class));
    }

    public DownloadSessionApiInterface(DownloadSessionProvider impl) {
        super("com.vmware.content.library.item.download_session");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new KeepAliveApiMethod());
        this.registerMethod((ApiMethod)new CancelApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new FailApiMethod());
    }

    private class FailApiMethod
    extends ApiMethodSkeleton {
        public FailApiMethod() {
            super(DownloadSessionApiInterface.this.getIdentifier(), "fail", DownloadSessionDefinitions.__failInput, DownloadSessionDefinitions.__failOutput, DownloadSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__failInput, DownloadSessionApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            String clientErrorMessage = (String)extr.valueForField("client_error_message");
            DownloadSessionApiInterface.this.impl.fail(downloadSessionId, clientErrorMessage, (AsyncContext<Void>)new AsyncContextImpl(DownloadSessionApiInterface.this.getTypeConverter(), DownloadSessionDefinitions.__failOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(DownloadSessionApiInterface.this.getIdentifier(), "delete", DownloadSessionDefinitions.__deleteInput, DownloadSessionDefinitions.__deleteOutput, DownloadSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__deleteInput, DownloadSessionApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            DownloadSessionApiInterface.this.impl.delete(downloadSessionId, (AsyncContext<Void>)new AsyncContextImpl(DownloadSessionApiInterface.this.getTypeConverter(), DownloadSessionDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CancelApiMethod
    extends ApiMethodSkeleton {
        public CancelApiMethod() {
            super(DownloadSessionApiInterface.this.getIdentifier(), "cancel", DownloadSessionDefinitions.__cancelInput, DownloadSessionDefinitions.__cancelOutput, DownloadSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__cancelInput, DownloadSessionApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            DownloadSessionApiInterface.this.impl.cancel(downloadSessionId, (AsyncContext<Void>)new AsyncContextImpl(DownloadSessionApiInterface.this.getTypeConverter(), DownloadSessionDefinitions.__cancelOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class KeepAliveApiMethod
    extends ApiMethodSkeleton {
        public KeepAliveApiMethod() {
            super(DownloadSessionApiInterface.this.getIdentifier(), "keep_alive", DownloadSessionDefinitions.__keepAliveInput, DownloadSessionDefinitions.__keepAliveOutput, DownloadSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__keepAliveInput, DownloadSessionApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            Long progress = (Long)extr.valueForField("progress");
            DownloadSessionApiInterface.this.impl.keepAlive(downloadSessionId, progress, (AsyncContext<Void>)new AsyncContextImpl(DownloadSessionApiInterface.this.getTypeConverter(), DownloadSessionDefinitions.__keepAliveOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(DownloadSessionApiInterface.this.getIdentifier(), "list", DownloadSessionDefinitions.__listInput, DownloadSessionDefinitions.__listOutput, DownloadSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__listInput, DownloadSessionApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            DownloadSessionApiInterface.this.impl.list(libraryItemId, (AsyncContext<List<String>>)new AsyncContextImpl(DownloadSessionApiInterface.this.getTypeConverter(), DownloadSessionDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(DownloadSessionApiInterface.this.getIdentifier(), "get", DownloadSessionDefinitions.__getInput, DownloadSessionDefinitions.__getOutput, DownloadSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__getInput, DownloadSessionApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            DownloadSessionApiInterface.this.impl.get(downloadSessionId, (AsyncContext<DownloadSessionModel>)new AsyncContextImpl(DownloadSessionApiInterface.this.getTypeConverter(), DownloadSessionDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(DownloadSessionApiInterface.this.getIdentifier(), "create", DownloadSessionDefinitions.__createInput, DownloadSessionDefinitions.__createOutput, DownloadSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__createInput, DownloadSessionApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            DownloadSessionModel createSpec = (DownloadSessionModel)extr.valueForField("create_spec");
            DownloadSessionApiInterface.this.impl.create(clientToken, createSpec, (AsyncContext<String>)new AsyncContextImpl(DownloadSessionApiInterface.this.getTypeConverter(), DownloadSessionDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

