/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.DownloadSessionDefinitions;
import com.vmware.content.library.item.DownloadSessionModel;
import com.vmware.content.library.item.DownloadSessionSyncProvider;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class DownloadSessionSyncApiInterface
extends ApiInterfaceSkeleton {
    private DownloadSessionSyncProvider impl;

    public DownloadSessionSyncApiInterface() {
        this((Class<? extends DownloadSessionSyncProvider>)null);
    }

    public DownloadSessionSyncApiInterface(Class<? extends DownloadSessionSyncProvider> implClass) {
        this((DownloadSessionSyncProvider)DownloadSessionSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.DownloadSessionImpl", DownloadSessionSyncProvider.class));
    }

    public DownloadSessionSyncApiInterface(DownloadSessionSyncProvider impl) {
        super("com.vmware.content.library.item.download_session");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new KeepAliveApiMethod());
        this.registerMethod((ApiMethod)new CancelApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new FailApiMethod());
    }

    private class FailApiMethod
    extends ApiMethodSkeleton {
        public FailApiMethod() {
            super(DownloadSessionSyncApiInterface.this.getIdentifier(), "fail", DownloadSessionDefinitions.__failInput, DownloadSessionDefinitions.__failOutput, DownloadSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__failInput, DownloadSessionSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            String clientErrorMessage = (String)extr.valueForField("client_error_message");
            try {
                DownloadSessionSyncApiInterface.this.impl.fail(downloadSessionId, clientErrorMessage, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(DownloadSessionSyncApiInterface.this.getIdentifier(), "delete", DownloadSessionDefinitions.__deleteInput, DownloadSessionDefinitions.__deleteOutput, DownloadSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__deleteInput, DownloadSessionSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            try {
                DownloadSessionSyncApiInterface.this.impl.delete(downloadSessionId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CancelApiMethod
    extends ApiMethodSkeleton {
        public CancelApiMethod() {
            super(DownloadSessionSyncApiInterface.this.getIdentifier(), "cancel", DownloadSessionDefinitions.__cancelInput, DownloadSessionDefinitions.__cancelOutput, DownloadSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__cancelInput, DownloadSessionSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            try {
                DownloadSessionSyncApiInterface.this.impl.cancel(downloadSessionId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class KeepAliveApiMethod
    extends ApiMethodSkeleton {
        public KeepAliveApiMethod() {
            super(DownloadSessionSyncApiInterface.this.getIdentifier(), "keep_alive", DownloadSessionDefinitions.__keepAliveInput, DownloadSessionDefinitions.__keepAliveOutput, DownloadSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__keepAliveInput, DownloadSessionSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            Long progress = (Long)extr.valueForField("progress");
            try {
                DownloadSessionSyncApiInterface.this.impl.keepAlive(downloadSessionId, progress, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(DownloadSessionSyncApiInterface.this.getIdentifier(), "list", DownloadSessionDefinitions.__listInput, DownloadSessionDefinitions.__listOutput, DownloadSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__listInput, DownloadSessionSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)DownloadSessionSyncApiInterface.this.getTypeConverter().convertToVapi(DownloadSessionSyncApiInterface.this.impl.list(libraryItemId, invocationContext), DownloadSessionDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(DownloadSessionSyncApiInterface.this.getIdentifier(), "get", DownloadSessionDefinitions.__getInput, DownloadSessionDefinitions.__getOutput, DownloadSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__getInput, DownloadSessionSyncApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)DownloadSessionSyncApiInterface.this.getTypeConverter().convertToVapi((Object)DownloadSessionSyncApiInterface.this.impl.get(downloadSessionId, invocationContext), DownloadSessionDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(DownloadSessionSyncApiInterface.this.getIdentifier(), "create", DownloadSessionDefinitions.__createInput, DownloadSessionDefinitions.__createOutput, DownloadSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, DownloadSessionDefinitions.__createInput, DownloadSessionSyncApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            DownloadSessionModel createSpec = (DownloadSessionModel)extr.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)DownloadSessionSyncApiInterface.this.getTypeConverter().convertToVapi((Object)DownloadSessionSyncApiInterface.this.impl.create(clientToken, createSpec, invocationContext), DownloadSessionDefinitions.__createOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

