/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.FileDefinitions;
import com.vmware.content.library.item.FileProvider;
import com.vmware.content.library.item.FileTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class FileApiInterface
extends ApiInterfaceSkeleton {
    private FileProvider impl;

    public FileApiInterface() {
        this((Class<? extends FileProvider>)null);
    }

    public FileApiInterface(Class<? extends FileProvider> implClass) {
        this((FileProvider)FileApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.FileImpl", FileProvider.class));
    }

    public FileApiInterface(FileProvider impl) {
        super("com.vmware.content.library.item.file");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "list", FileDefinitions.__listInput, FileDefinitions.__listOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__listInput, FileApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            FileApiInterface.this.impl.list(libraryItemId, (AsyncContext<List<FileTypes.Info>>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "get", FileDefinitions.__getInput, FileDefinitions.__getOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__getInput, FileApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            String name = (String)extr.valueForField("name");
            FileApiInterface.this.impl.get(libraryItemId, name, (AsyncContext<FileTypes.Info>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

