/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.FileDefinitions;
import com.vmware.content.library.item.FileSyncProvider;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class FileSyncApiInterface
extends ApiInterfaceSkeleton {
    private FileSyncProvider impl;

    public FileSyncApiInterface() {
        this((Class<? extends FileSyncProvider>)null);
    }

    public FileSyncApiInterface(Class<? extends FileSyncProvider> implClass) {
        this((FileSyncProvider)FileSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.FileImpl", FileSyncProvider.class));
    }

    public FileSyncApiInterface(FileSyncProvider impl) {
        super("com.vmware.content.library.item.file");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "list", FileDefinitions.__listInput, FileDefinitions.__listOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__listInput, FileSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi(FileSyncApiInterface.this.impl.list(libraryItemId, invocationContext), FileDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(FileSyncApiInterface.this.getIdentifier(), "get", FileDefinitions.__getInput, FileDefinitions.__getOutput, FileSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__getInput, FileSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            String name = (String)extr.valueForField("name");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)FileSyncApiInterface.this.getTypeConverter().convertToVapi((Object)FileSyncApiInterface.this.impl.get(libraryItemId, name, invocationContext), FileDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

