/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.StorageDefinitions;
import com.vmware.content.library.item.StorageProvider;
import com.vmware.content.library.item.StorageTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class StorageApiInterface
extends ApiInterfaceSkeleton {
    private StorageProvider impl;

    public StorageApiInterface() {
        this((Class<? extends StorageProvider>)null);
    }

    public StorageApiInterface(Class<? extends StorageProvider> implClass) {
        this((StorageProvider)StorageApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.StorageImpl", StorageProvider.class));
    }

    public StorageApiInterface(StorageProvider impl) {
        super("com.vmware.content.library.item.storage");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(StorageApiInterface.this.getIdentifier(), "list", StorageDefinitions.__listInput, StorageDefinitions.__listOutput, StorageApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, StorageDefinitions.__listInput, StorageApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            StorageApiInterface.this.impl.list(libraryItemId, (AsyncContext<List<StorageTypes.Info>>)new AsyncContextImpl(StorageApiInterface.this.getTypeConverter(), StorageDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(StorageApiInterface.this.getIdentifier(), "get", StorageDefinitions.__getInput, StorageDefinitions.__getOutput, StorageApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, StorageDefinitions.__getInput, StorageApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            String fileName = (String)extr.valueForField("file_name");
            StorageApiInterface.this.impl.get(libraryItemId, fileName, (AsyncContext<List<StorageTypes.Info>>)new AsyncContextImpl(StorageApiInterface.this.getTypeConverter(), StorageDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

