/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.StorageDefinitions;
import com.vmware.content.library.item.StorageSyncProvider;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class StorageSyncApiInterface
extends ApiInterfaceSkeleton {
    private StorageSyncProvider impl;

    public StorageSyncApiInterface() {
        this((Class<? extends StorageSyncProvider>)null);
    }

    public StorageSyncApiInterface(Class<? extends StorageSyncProvider> implClass) {
        this((StorageSyncProvider)StorageSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.StorageImpl", StorageSyncProvider.class));
    }

    public StorageSyncApiInterface(StorageSyncProvider impl) {
        super("com.vmware.content.library.item.storage");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(StorageSyncApiInterface.this.getIdentifier(), "list", StorageDefinitions.__listInput, StorageDefinitions.__listOutput, StorageSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, StorageDefinitions.__listInput, StorageSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)StorageSyncApiInterface.this.getTypeConverter().convertToVapi(StorageSyncApiInterface.this.impl.list(libraryItemId, invocationContext), StorageDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(StorageSyncApiInterface.this.getIdentifier(), "get", StorageDefinitions.__getInput, StorageDefinitions.__getOutput, StorageSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, StorageDefinitions.__getInput, StorageSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            String fileName = (String)extr.valueForField("file_name");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)StorageSyncApiInterface.this.getTypeConverter().convertToVapi(StorageSyncApiInterface.this.impl.get(libraryItemId, fileName, invocationContext), StorageDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

