/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.UpdateSessionDefinitions;
import com.vmware.content.library.item.UpdateSessionModel;
import com.vmware.content.library.item.UpdateSessionProvider;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class UpdateSessionApiInterface
extends ApiInterfaceSkeleton {
    private UpdateSessionProvider impl;

    public UpdateSessionApiInterface() {
        this((Class<? extends UpdateSessionProvider>)null);
    }

    public UpdateSessionApiInterface(Class<? extends UpdateSessionProvider> implClass) {
        this((UpdateSessionProvider)UpdateSessionApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.UpdateSessionImpl", UpdateSessionProvider.class));
    }

    public UpdateSessionApiInterface(UpdateSessionProvider impl) {
        super("com.vmware.content.library.item.update_session");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new CompleteApiMethod());
        this.registerMethod((ApiMethod)new KeepAliveApiMethod());
        this.registerMethod((ApiMethod)new CancelApiMethod());
        this.registerMethod((ApiMethod)new FailApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "delete", UpdateSessionDefinitions.__deleteInput, UpdateSessionDefinitions.__deleteOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__deleteInput, UpdateSessionApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            UpdateSessionApiInterface.this.impl.delete(updateSessionId, (AsyncContext<Void>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__deleteOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class FailApiMethod
    extends ApiMethodSkeleton {
        public FailApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "fail", UpdateSessionDefinitions.__failInput, UpdateSessionDefinitions.__failOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__failInput, UpdateSessionApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            String clientErrorMessage = (String)extr.valueForField("client_error_message");
            UpdateSessionApiInterface.this.impl.fail(updateSessionId, clientErrorMessage, (AsyncContext<Void>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__failOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CancelApiMethod
    extends ApiMethodSkeleton {
        public CancelApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "cancel", UpdateSessionDefinitions.__cancelInput, UpdateSessionDefinitions.__cancelOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__cancelInput, UpdateSessionApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            UpdateSessionApiInterface.this.impl.cancel(updateSessionId, (AsyncContext<Void>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__cancelOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class KeepAliveApiMethod
    extends ApiMethodSkeleton {
        public KeepAliveApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "keep_alive", UpdateSessionDefinitions.__keepAliveInput, UpdateSessionDefinitions.__keepAliveOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__keepAliveInput, UpdateSessionApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            Long clientProgress = (Long)extr.valueForField("client_progress");
            UpdateSessionApiInterface.this.impl.keepAlive(updateSessionId, clientProgress, (AsyncContext<Void>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__keepAliveOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CompleteApiMethod
    extends ApiMethodSkeleton {
        public CompleteApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "complete", UpdateSessionDefinitions.__completeInput, UpdateSessionDefinitions.__completeOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__completeInput, UpdateSessionApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            UpdateSessionApiInterface.this.impl.complete(updateSessionId, (AsyncContext<Void>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__completeOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "list", UpdateSessionDefinitions.__listInput, UpdateSessionDefinitions.__listOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__listInput, UpdateSessionApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            UpdateSessionApiInterface.this.impl.list(libraryItemId, (AsyncContext<List<String>>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "get", UpdateSessionDefinitions.__getInput, UpdateSessionDefinitions.__getOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__getInput, UpdateSessionApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            UpdateSessionApiInterface.this.impl.get(updateSessionId, (AsyncContext<UpdateSessionModel>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(UpdateSessionApiInterface.this.getIdentifier(), "create", UpdateSessionDefinitions.__createInput, UpdateSessionDefinitions.__createOutput, UpdateSessionApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceBusy;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__createInput, UpdateSessionApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            UpdateSessionModel createSpec = (UpdateSessionModel)extr.valueForField("create_spec");
            UpdateSessionApiInterface.this.impl.create(clientToken, createSpec, (AsyncContext<String>)new AsyncContextImpl(UpdateSessionApiInterface.this.getTypeConverter(), UpdateSessionDefinitions.__createOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

