/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item;

import com.vmware.content.library.item.UpdateSessionDefinitions;
import com.vmware.content.library.item.UpdateSessionModel;
import com.vmware.content.library.item.UpdateSessionSyncProvider;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class UpdateSessionSyncApiInterface
extends ApiInterfaceSkeleton {
    private UpdateSessionSyncProvider impl;

    public UpdateSessionSyncApiInterface() {
        this((Class<? extends UpdateSessionSyncProvider>)null);
    }

    public UpdateSessionSyncApiInterface(Class<? extends UpdateSessionSyncProvider> implClass) {
        this((UpdateSessionSyncProvider)UpdateSessionSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.impl.UpdateSessionImpl", UpdateSessionSyncProvider.class));
    }

    public UpdateSessionSyncApiInterface(UpdateSessionSyncProvider impl) {
        super("com.vmware.content.library.item.update_session");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new CompleteApiMethod());
        this.registerMethod((ApiMethod)new KeepAliveApiMethod());
        this.registerMethod((ApiMethod)new CancelApiMethod());
        this.registerMethod((ApiMethod)new FailApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "delete", UpdateSessionDefinitions.__deleteInput, UpdateSessionDefinitions.__deleteOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__deleteInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            try {
                UpdateSessionSyncApiInterface.this.impl.delete(updateSessionId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class FailApiMethod
    extends ApiMethodSkeleton {
        public FailApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "fail", UpdateSessionDefinitions.__failInput, UpdateSessionDefinitions.__failOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__failInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            String clientErrorMessage = (String)extr.valueForField("client_error_message");
            try {
                UpdateSessionSyncApiInterface.this.impl.fail(updateSessionId, clientErrorMessage, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CancelApiMethod
    extends ApiMethodSkeleton {
        public CancelApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "cancel", UpdateSessionDefinitions.__cancelInput, UpdateSessionDefinitions.__cancelOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__cancelInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            try {
                UpdateSessionSyncApiInterface.this.impl.cancel(updateSessionId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class KeepAliveApiMethod
    extends ApiMethodSkeleton {
        public KeepAliveApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "keep_alive", UpdateSessionDefinitions.__keepAliveInput, UpdateSessionDefinitions.__keepAliveOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__keepAliveInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            Long clientProgress = (Long)extr.valueForField("client_progress");
            try {
                UpdateSessionSyncApiInterface.this.impl.keepAlive(updateSessionId, clientProgress, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CompleteApiMethod
    extends ApiMethodSkeleton {
        public CompleteApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "complete", UpdateSessionDefinitions.__completeInput, UpdateSessionDefinitions.__completeOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__completeInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            try {
                UpdateSessionSyncApiInterface.this.impl.complete(updateSessionId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "list", UpdateSessionDefinitions.__listInput, UpdateSessionDefinitions.__listOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__listInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String libraryItemId = (String)extr.valueForField("library_item_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)UpdateSessionSyncApiInterface.this.getTypeConverter().convertToVapi(UpdateSessionSyncApiInterface.this.impl.list(libraryItemId, invocationContext), UpdateSessionDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "get", UpdateSessionDefinitions.__getInput, UpdateSessionDefinitions.__getOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__getInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)UpdateSessionSyncApiInterface.this.getTypeConverter().convertToVapi((Object)UpdateSessionSyncApiInterface.this.impl.get(updateSessionId, invocationContext), UpdateSessionDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(UpdateSessionSyncApiInterface.this.getIdentifier(), "create", UpdateSessionDefinitions.__createInput, UpdateSessionDefinitions.__createOutput, UpdateSessionSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidElementType;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceBusy;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, UpdateSessionDefinitions.__createInput, UpdateSessionSyncApiInterface.this.getTypeConverter());
            String clientToken = (String)extr.valueForField("client_token");
            UpdateSessionModel createSpec = (UpdateSessionModel)extr.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)UpdateSessionSyncApiInterface.this.getTypeConverter().convertToVapi((Object)UpdateSessionSyncApiInterface.this.impl.create(clientToken, createSpec, invocationContext), UpdateSessionDefinitions.__createOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

