/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item.downloadsession;

import com.vmware.content.library.item.downloadsession.FileDefinitions;
import com.vmware.content.library.item.downloadsession.FileProvider;
import com.vmware.content.library.item.downloadsession.FileTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class FileApiInterface
extends ApiInterfaceSkeleton {
    private FileProvider impl;

    public FileApiInterface() {
        this((Class<? extends FileProvider>)null);
    }

    public FileApiInterface(Class<? extends FileProvider> implClass) {
        this((FileProvider)FileApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.downloadsession.impl.FileImpl", FileProvider.class));
    }

    public FileApiInterface(FileProvider impl) {
        super("com.vmware.content.library.item.downloadsession.file");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new PrepareApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "get", FileDefinitions.__getInput, FileDefinitions.__getOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__getInput, FileApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            String fileName = (String)extr.valueForField("file_name");
            FileApiInterface.this.impl.get(downloadSessionId, fileName, (AsyncContext<FileTypes.Info>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class PrepareApiMethod
    extends ApiMethodSkeleton {
        public PrepareApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "prepare", FileDefinitions.__prepareInput, FileDefinitions.__prepareOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__prepareInput, FileApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            String fileName = (String)extr.valueForField("file_name");
            FileTypes.EndpointType endpointType = (FileTypes.EndpointType)((Object)extr.valueForField("endpoint_type"));
            FileApiInterface.this.impl.prepare(downloadSessionId, fileName, endpointType, (AsyncContext<FileTypes.Info>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__prepareOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "list", FileDefinitions.__listInput, FileDefinitions.__listOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__listInput, FileApiInterface.this.getTypeConverter());
            String downloadSessionId = (String)extr.valueForField("download_session_id");
            FileApiInterface.this.impl.list(downloadSessionId, (AsyncContext<List<FileTypes.Info>>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

