/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.content.library.item.updatesession;

import com.vmware.content.library.item.TransferEndpoint;
import com.vmware.content.library.item.updatesession.FileDefinitions;
import com.vmware.content.library.item.updatesession.FileProvider;
import com.vmware.content.library.item.updatesession.FileTypes;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class FileApiInterface
extends ApiInterfaceSkeleton {
    private FileProvider impl;

    public FileApiInterface() {
        this((Class<? extends FileProvider>)null);
    }

    public FileApiInterface(Class<? extends FileProvider> implClass) {
        this((FileProvider)FileApiInterface.createImplInstance(implClass, (String)"com.vmware.content.library.item.updatesession.impl.FileImpl", FileProvider.class));
    }

    public FileApiInterface(FileProvider impl) {
        super("com.vmware.content.library.item.updatesession.file");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ValidateApiMethod());
        this.registerMethod((ApiMethod)new AddApiMethod());
        this.registerMethod((ApiMethod)new RemoveApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ProbeApiMethod());
    }

    private class ProbeApiMethod
    extends ApiMethodSkeleton {
        public ProbeApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "probe", FileDefinitions.__probeInput, FileDefinitions.__probeOutput, FileApiInterface.this.getTypeConverter(), null, false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__probeInput, FileApiInterface.this.getTypeConverter());
            TransferEndpoint sourceEndpoint = (TransferEndpoint)extr.valueForField("source_endpoint");
            FileApiInterface.this.impl.probe(sourceEndpoint, (AsyncContext<FileTypes.ProbeResult>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__probeOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "get", FileDefinitions.__getInput, FileDefinitions.__getOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__getInput, FileApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            String fileName = (String)extr.valueForField("file_name");
            FileApiInterface.this.impl.get(updateSessionId, fileName, (AsyncContext<FileTypes.Info>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__getOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "list", FileDefinitions.__listInput, FileDefinitions.__listOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__listInput, FileApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            FileApiInterface.this.impl.list(updateSessionId, (AsyncContext<List<FileTypes.Info>>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__listOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class RemoveApiMethod
    extends ApiMethodSkeleton {
        public RemoveApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "remove", FileDefinitions.__removeInput, FileDefinitions.__removeOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__removeInput, FileApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            String fileName = (String)extr.valueForField("file_name");
            FileApiInterface.this.impl.remove(updateSessionId, fileName, (AsyncContext<Void>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__removeOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class AddApiMethod
    extends ApiMethodSkeleton {
        public AddApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "add", FileDefinitions.__addInput, FileDefinitions.__addOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__addInput, FileApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            FileTypes.AddSpec fileSpec = (FileTypes.AddSpec)extr.valueForField("file_spec");
            FileApiInterface.this.impl.add(updateSessionId, fileSpec, (AsyncContext<FileTypes.Info>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__addOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ValidateApiMethod
    extends ApiMethodSkeleton {
        public ValidateApiMethod() {
            super(FileApiInterface.this.getIdentifier(), "validate", FileDefinitions.__validateInput, FileDefinitions.__validateOutput, FileApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }), false, false);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, FileDefinitions.__validateInput, FileApiInterface.this.getTypeConverter());
            String updateSessionId = (String)extr.valueForField("update_session_id");
            FileApiInterface.this.impl.validate(updateSessionId, (AsyncContext<FileTypes.ValidationResult>)new AsyncContextImpl(FileApiInterface.this.getTypeConverter(), FileDefinitions.__validateOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

