/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.ceip.CeipApi;
import com.vmware.ph.phservice.ceip.CeipApiProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CeipConfigProviderImpl
implements CeipConfigProvider {
    private static final Log _log = LogFactory.getLog(CeipConfigProviderImpl.class);
    private final List<CeipApiProvider> _ceipApiProviders;

    public CeipConfigProviderImpl(CeipApiProvider ceipApiProvider) {
        this._ceipApiProviders = new ArrayList<CeipApiProvider>(1);
        this._ceipApiProviders.add(ceipApiProvider);
    }

    public CeipConfigProviderImpl(List<CeipApiProvider> ceipApiProviders) {
        this._ceipApiProviders = ceipApiProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCeipEnabled() {
        boolean ceipEnabled = false;
        for (CeipApiProvider ceipApiProvider : this._ceipApiProviders) {
            CeipApi ceipApi = ceipApiProvider.getCeipApi();
            if (ceipApi == null) continue;
            try {
                ceipEnabled = CeipConfigProviderImpl.getIsConsentAccepted(ceipApi);
                break;
            }
            finally {
                ceipApiProvider.releaseCeipApi(ceipApi);
            }
        }
        return ceipEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getIsConsentAccepted(CeipApi ceipApi) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CeipConfigProviderImpl.class.getClassLoader());
            boolean ceipEnabled = ceipApi.isConsentAccepted();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("ceipEnabled read from db: " + ceipEnabled));
            }
            boolean bl = ceipEnabled;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

