/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.ceip.CeipApi;
import com.vmware.ph.phservice.ciscommon.CisContext;
import com.vmware.ph.sharedcfg.ceip.provider.impl.CeipConfigProviderImpl;
import com.vmware.vim.sso.client.SamlToken;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GcCeipApiImpl
implements CeipApi {
    private static final Log _log = LogFactory.getLog(GcCeipApiImpl.class);
    private final CisContext _cisContext;
    private CeipConfigProvider _gcCeipConfigProvider;

    public GcCeipApiImpl(CisContext cisContext) {
        this._cisContext = cisContext;
    }

    @Override
    public Boolean isConsentAccepted() {
        this.initGcCeipConfigProvider();
        if (this._gcCeipConfigProvider != null) {
            return this._gcCeipConfigProvider.isCeipEnabled();
        }
        return false;
    }

    @Override
    public void setConsentAccepted(boolean consentAccepted) {
    }

    @Override
    public boolean isConsentChangeAllowed(SamlToken samlToken, PrivateKey privateKey) {
        return true;
    }

    @Override
    public void sync() {
    }

    private void initGcCeipConfigProvider() {
        if (this._gcCeipConfigProvider != null) {
            return;
        }
        try {
            this._gcCeipConfigProvider = new CeipConfigProviderImpl(this._cisContext.getLookupSdkUri().toString(), this._cisContext.getTrustedStore(), null);
        }
        catch (URISyntaxException e) {
            _log.debug((Object)"Failed to create Global CEIP configuration provider.", (Throwable)e);
        }
    }
}

