/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.common.json.JsonSerializer;
import com.vmware.ph.exceptions.Bug;
import com.vmware.ph.phservice.ceip.ConsentException;
import com.vmware.ph.phservice.ceip.ConsentManager;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.vim.binding.phonehome.data.ConsentConfigurationData;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.exception.RemoteException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcConsentManager
implements ConsentManager {
    private static final String CONSENT_VC_SETTING_KEY = "VirtualCenter.DataCollector.ConsentData";
    private static final Log _log = LogFactory.getLog(VcConsentManager.class);
    private final VcClient _vcClient;

    public VcConsentManager(VcClient vcClient) {
        this._vcClient = vcClient;
    }

    @Override
    public ConsentConfigurationData readConsent() throws ConsentException {
        Object value = this.readOptionValue(this._vcClient, CONSENT_VC_SETTING_KEY);
        if (value == null) {
            _log.debug((Object)"ConsentData read from OptionManager is null.");
            return null;
        }
        String stringValue = (String)value;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("ConsentData read from OptionManager is: " + stringValue));
        }
        try {
            ConsentConfigurationData result = (ConsentConfigurationData)JsonSerializer.readObject((String)stringValue, ConsentConfigurationData.class);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("readConsent completed successfully: " + result));
            }
            return result;
        }
        catch (IOException e) {
            _log.warn((Object)("Cannot deserialize " + ConsentConfigurationData.class.getName() + " from the following value: " + stringValue + ". Will default to null."));
            return null;
        }
    }

    @Override
    public void writeConsent(ConsentConfigurationData consent) throws ConsentException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("writeConsent: start, consent: " + consent));
        }
        String stringValue = null;
        if (consent != null) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                JsonSerializer.writeObject((Object)consent, (OutputStream)outputStream);
                stringValue = outputStream.toString(StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                throw new Bug("Failed to serialize " + ConsentConfigurationData.class.getName() + " to Json.", (Throwable)e);
            }
        }
        this.writeOptionValue(this._vcClient, CONSENT_VC_SETTING_KEY, stringValue);
        _log.debug((Object)"writeConsent: completed successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionManager initializeOptionManager(VcClient vcClient) {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader thisClassLoader = VcConsentManager.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(thisClassLoader);
        try {
            OptionManager optionManager;
            ManagedObjectReference vcSettingsId = vcClient.getServiceInstanceContent().getSetting();
            OptionManager optionManager2 = optionManager = (OptionManager)vcClient.createMo(vcSettingsId);
            return optionManager2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    private Object readOptionValue(VcClient vcClient, String key) throws ConsentException {
        Object firstResult;
        OptionValue[] result;
        _log.debug((Object)("Retrieving value for option with key: " + key));
        OptionManager optionManager = this.initializeOptionManager(vcClient);
        if (optionManager == null) {
            throw new ConsentException("Cannot initialize OptionManager");
        }
        try {
            result = optionManager.queryView(key);
        }
        catch (InvalidName e) {
            throw new ConsentException("Cannot find option with name " + key + " .", e);
        }
        catch (RuntimeFault e) {
            throw new ConsentException("Failed to read option with name " + key + " .", e);
        }
        catch (RemoteException e) {
            throw new ConsentException("Failed to read option with name " + key + " .", e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Got %d result(s).", result.length));
        }
        Object object = firstResult = result.length > 0 ? result[0].getValue() : null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Retrieved %s = %s", key, firstResult));
        }
        return firstResult;
    }

    private void writeOptionValue(VcClient vcClient, String key, Object value) throws ConsentException {
        OptionManager optionManager = this.initializeOptionManager(vcClient);
        if (optionManager == null) {
            throw new ConsentException("Unable to initialze OptionManager");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Updating option %s with value %s", key, value));
        }
        try {
            OptionValue optionValue = new OptionValue(key, value);
            optionManager.updateValues(new OptionValue[]{optionValue});
        }
        catch (InvalidName e) {
            throw new ConsentException(String.format("vCenter service does not support configuration key `%s' (incompatible vCenter version)", key), e);
        }
        catch (RuntimeFault e) {
            throw new ConsentException("Failed to write option " + key + " with value " + value + ".", e);
        }
        catch (RemoteException e) {
            throw new ConsentException("Failed to write option " + key + " with value " + value + ".", e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("Updating option %s with value %s completed successfully.", key, value));
        }
    }
}

