/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ceip.impl;

import com.vmware.ph.phservice.ceip.CeipApi;
import com.vmware.ph.phservice.ceip.CeipApiProvider;
import com.vmware.ph.phservice.ceip.impl.CeipApiImpl;
import com.vmware.ph.phservice.ceip.impl.GlobalConsentManager;
import com.vmware.ph.phservice.ceip.impl.VcConsentManager;
import com.vmware.ph.phservice.ceip.impl.VimContextCeipApiAuthenticationValidator;
import com.vmware.ph.phservice.client.CcsClientUtil;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextProvider;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.vmomicommon.client.VmomiClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VimContextCeipApiProviderImpl
implements CeipApiProvider {
    private final VimContextProvider _vimContextProvider;
    private final CcsVmomiClientFactory _ccsVmomiClientFactory;
    private final Map<CeipApi, CeipApiResources> _ceipApiToCeipApiResources;

    public VimContextCeipApiProviderImpl(VimContextProvider vimContextProvider) {
        this(vimContextProvider, new CcsVmomiClientFactory());
    }

    public VimContextCeipApiProviderImpl(VimContextProvider vimContextProvider, CcsVmomiClientFactory ccsVmomiClientFactory) {
        this._vimContextProvider = vimContextProvider;
        this._ccsVmomiClientFactory = ccsVmomiClientFactory;
        this._ceipApiToCeipApiResources = new ConcurrentHashMap<CeipApi, CeipApiResources>();
    }

    @Override
    public CeipApi getCeipApi() {
        VimContext vimContext = this._vimContextProvider.getVimContext();
        VmomiClient ccsClient = this._ccsVmomiClientFactory.createCcsVmomiClient(vimContext);
        VcClient vcClient = vimContext.getVcClientBuilder(true).build();
        CeipApiImpl ceipApi = new CeipApiImpl(new VcConsentManager(vcClient), new GlobalConsentManager(ccsClient), new VimContextCeipApiAuthenticationValidator(vimContext));
        this._ceipApiToCeipApiResources.put(ceipApi, new CeipApiResources(vcClient, ccsClient));
        return ceipApi;
    }

    @Override
    public void releaseCeipApi(CeipApi ceipApi) {
        CeipApiResources ceipApiResources = this._ceipApiToCeipApiResources.get(ceipApi);
        if (ceipApiResources != null) {
            ceipApiResources.close();
            this._ceipApiToCeipApiResources.remove(ceipApi);
        }
    }

    @Override
    public void close() {
    }

    void addCeipApiResources(CeipApi ceipApi, CeipApiResources ceipApiResources) {
        this._ceipApiToCeipApiResources.put(ceipApi, ceipApiResources);
    }

    static class CcsVmomiClientFactory {
        CcsVmomiClientFactory() {
        }

        public VmomiClient createCcsVmomiClient(VimContext vimContext) {
            return CcsClientUtil.createCcsVmomiClient(vimContext);
        }
    }

    static class CeipApiResources
    implements AutoCloseable {
        private final VcClient _vcClient;
        private final VmomiClient _ccsClient;

        public CeipApiResources(VcClient vcClient, VmomiClient ccsClient) {
            this._vcClient = vcClient;
            this._ccsClient = ccsClient;
        }

        @Override
        public synchronized void close() {
            this._vcClient.close();
            this._ccsClient.close();
        }
    }
}

