/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ciscommon;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.ph.phservice.ciscommon.lookup.LookupClientBuilder;
import com.vmware.ph.phservice.ciscommon.sso.SsoTokenProvider;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.Executors;

public class CisContext {
    private final KeyStore _vimTrustStore;
    private ThumbprintVerifier _vimThumbprintVerifier;
    private final URI _lookupSdkUri;
    private final LookupClientBuilder _lookupClientBuilder;
    private final SsoTokenProvider _ssoTokenProvider;

    public CisContext(KeyStore vimTrustStore, URI lookupSdkUri, LookupClientBuilder lookupClientBuilder, SsoTokenProvider ssoTokenProvider) {
        this._vimTrustStore = vimTrustStore;
        this._lookupSdkUri = lookupSdkUri;
        this._lookupClientBuilder = lookupClientBuilder;
        this._ssoTokenProvider = ssoTokenProvider;
    }

    public void setVimThumbprintVerifier(ThumbprintVerifier vimThumbprintVerifier) {
        this._vimThumbprintVerifier = vimThumbprintVerifier;
    }

    public SsoTokenProvider getSsoTokenProvider() {
        return this._ssoTokenProvider;
    }

    public LookupClientBuilder getLookupClientBuilder(boolean tryToDetermineSuitableVersion) {
        if (!tryToDetermineSuitableVersion) {
            return this._lookupClientBuilder;
        }
        LookupClientBuilder lookupClientBuilder = LookupClientBuilder.forLookupVersion(LookupClientBuilder.LATEST_LOOKUP_VERSION_CLASS, Executors.newSingleThreadExecutor()).withTrust(this._vimTrustStore, this._vimThumbprintVerifier).withLookupSdkUri(this._lookupSdkUri);
        try (LookupClient lookupClient = lookupClientBuilder.build();){
            boolean isSupported = true;
            try {
                ServiceRegistration sr = lookupClient.getServiceRegistration();
                if (sr == null) {
                    isSupported = false;
                }
            }
            catch (Exception e) {
                isSupported = false;
            }
            if (!isSupported) {
                lookupClientBuilder = this._lookupClientBuilder;
            }
        }
        return lookupClientBuilder;
    }

    public URI getLookupSdkUri() {
        return this._lookupSdkUri;
    }

    public KeyStore getTrustedStore() {
        return this._vimTrustStore;
    }
}

