/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ciscommon.lookup;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import java.net.URI;
import java.util.Objects;

public class ServiceLocatorUtil {
    public static ServiceRegistration.Info[] findServiceByServiceAndEndpointType(LookupClient lookupClient, ServiceRegistration.ServiceType serviceTypeFilter, ServiceRegistration.EndpointType endpointTypeFilter, String nodeId) {
        Objects.requireNonNull(lookupClient);
        ServiceRegistration.Info[] foundServices = null;
        ServiceRegistration serviceRegistration = lookupClient.getServiceRegistration();
        if (serviceRegistration == null) {
            return null;
        }
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setNodeId(nodeId);
        filter.setServiceType(serviceTypeFilter);
        filter.setEndpointType(endpointTypeFilter);
        foundServices = serviceRegistration.list(filter);
        return foundServices;
    }

    public static String getNodeIdByServiceId(LookupClient lookupClient, String serviceId) throws EntryNotFoundFault {
        Objects.requireNonNull(lookupClient);
        Objects.requireNonNull(serviceId);
        String nodeId = null;
        ServiceRegistration serviceRegistration = lookupClient.getServiceRegistration();
        if (serviceRegistration == null) {
            return null;
        }
        ServiceRegistration.Info serviceInfo = serviceRegistration.get(serviceId);
        if (serviceInfo != null) {
            nodeId = serviceInfo.getNodeId();
        }
        return nodeId;
    }

    public static URI getEndpointUriByEndpointType(LookupClient lookupClient, ServiceRegistration.EndpointType endpointTypeFilter) {
        Objects.requireNonNull(lookupClient);
        Objects.requireNonNull(endpointTypeFilter);
        ServiceRegistration.Info[] serviceList = ServiceLocatorUtil.findServiceByServiceAndEndpointType(lookupClient, null, endpointTypeFilter, null);
        String endpointType = endpointTypeFilter.type;
        URI serviceUri = null;
        if (serviceList != null && serviceList.length > 0) {
            for (ServiceRegistration.Info service : serviceList) {
                for (ServiceRegistration.Endpoint endpoint : service.getServiceEndpoints()) {
                    if (!endpointType.equals(endpoint.getEndpointType().getType())) continue;
                    serviceUri = endpoint.getUrl();
                    break;
                }
                if (serviceUri != null) break;
            }
        }
        return serviceUri;
    }
}

