/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.ciscommon.lookup.impl;

import com.vmware.ph.phservice.ciscommon.lookup.LookupClient;
import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.ServiceContent;
import com.vmware.vim.binding.lookup.ServiceInstance;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.version.version2;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;

public class LookupClientImpl
implements LookupClient {
    private static final ManagedObjectReference LS_SERVICE_INSTANCE_MO_REF = new ManagedObjectReference("LookupServiceInstance", "ServiceInstance");
    private final Class<?> _versionClass;
    private final URI _lsUri;
    private final HttpClientConfiguration _httpClientConfig;
    private final Client _vmomiClient;
    private final boolean _isServiceRegistrationSupported;
    private ServiceContent _serviceContent;
    private LookupService _lookupService;
    private ServiceRegistration _serviceRegistration;

    public LookupClientImpl(URI lsUri, Class<?> versionClass, HttpClientConfiguration httpClientConfig, VmodlContext vmodlContext) {
        this._versionClass = versionClass;
        this._lsUri = lsUri;
        this._httpClientConfig = httpClientConfig;
        this._vmomiClient = Client.Factory.createClient((URI)this._lsUri, this._versionClass, (VmodlContext)vmodlContext, (ClientConfiguration)this._httpClientConfig);
        VmodlVersion version22 = vmodlContext.getVmodlVersionMap().getVersion(version2.class);
        this._isServiceRegistrationSupported = vmodlContext.getVmodlVersionMap().getVersion(this._versionClass).isCompatible(version22);
    }

    @Override
    public LookupService getLookupService() {
        if (this._lookupService == null) {
            ServiceContent sc = this.getServiceContent();
            this._lookupService = this.getManagedObjectInt(LookupService.class, sc.getLookupService());
        }
        return this._lookupService;
    }

    @Override
    public ServiceRegistration getServiceRegistration() {
        ServiceContent sc;
        ManagedObjectReference srMoRef;
        if (this._isServiceRegistrationSupported && this._serviceRegistration == null && (srMoRef = (sc = this.getServiceContent()).getServiceRegistration()) != null) {
            this._serviceRegistration = this.getManagedObjectInt(ServiceRegistration.class, srMoRef);
        }
        return this._serviceRegistration;
    }

    @Override
    public void close() {
        if (this._vmomiClient != null) {
            this._vmomiClient.shutdown();
        }
    }

    private ServiceContent getServiceContent() {
        if (this._serviceContent == null) {
            ServiceInstance si = this.getManagedObjectInt(ServiceInstance.class, LS_SERVICE_INSTANCE_MO_REF);
            this._serviceContent = si.retrieveServiceContent();
        }
        return this._serviceContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ManagedObject> T getManagedObjectInt(Class<T> typeClass, ManagedObjectReference moRef) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ManagedObject managedObject = this._vmomiClient.createStub(typeClass, moRef);
            return (T)managedObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

