/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf.mapping;

import com.vmware.cis.data.api.ResultSet;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.NamedQueryResultSetMapping;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IndependentResultsMapping
implements NamedQueryResultSetMapping<Payload20> {
    private Map<String, Mapping<ResultSet, Payload20>> _queryNameToResultSetMapping;

    public IndependentResultsMapping() {
    }

    public IndependentResultsMapping(Map<String, Mapping<ResultSet, Payload20>> resultSetMappings) {
        this._queryNameToResultSetMapping = resultSetMappings;
    }

    @Override
    public Payload20 map(NamedQueryResultSet input, Context context) {
        Payload20.Builder payloadBuilder = new Payload20.Builder();
        Mapping<ResultSet, Payload20> mapping = this._queryNameToResultSetMapping.get(input.getQueryName());
        if (mapping != null) {
            Payload20 resultSetPayload = mapping.map(input.getResultSet(), context);
            payloadBuilder.add(resultSetPayload);
        }
        return payloadBuilder.build();
    }

    @Override
    public boolean isQuerySupported(String queryName) {
        return this._queryNameToResultSetMapping.containsKey(queryName);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return "IndependentResultsMapping [resultSetMappings=" + this._queryNameToResultSetMapping + "]";
    }
}

