/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf.mapping;

import com.vmware.ph.client.api.commondataformat20.types.JsonLd;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.VelocityHelper;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.VelocityJsonLdInvocationContext;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.VelocityJsonLdToJsonLdConverter;
import com.vmware.ph.phservice.collector.data.NamedPropertiesResourceItem;
import com.vmware.ph.phservice.common.cdf.jsonld20.VmodlToJsonLdSerializer;
import com.vmware.ph.phservice.vmomicommon.VmodlContextProvider;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.util.Arrays;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceItemToJsonLdMapping
implements Mapping<NamedPropertiesResourceItem, JsonLd> {
    private static final Log _log = LogFactory.getLog(ResourceItemToJsonLdMapping.class);
    protected String _forType;
    protected String _mappingCode;
    protected VelocityJsonLdInvocationContext velocityInvocationContext = null;

    public ResourceItemToJsonLdMapping(String forType, String mappingCode) {
        this._forType = forType;
        this._mappingCode = mappingCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonLd map(NamedPropertiesResourceItem input, Context context) {
        if (this.validateInput(input)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"The specified input object matches all expectations, now will try to produce result for it.");
            }
        } else {
            return null;
        }
        try {
            this.velocityInvocationContext = VelocityJsonLdInvocationContext.newInstance(input, context);
            if (!this._mappingCode.isEmpty()) {
                String logTag = "[" + this.getClass().getSimpleName() + " forType=" + this._forType + "]";
                String expressionResult = VelocityHelper.executeVelocityExpression(this._mappingCode, this.velocityInvocationContext.velocityEngine, this.velocityInvocationContext.velocityContext, logTag);
                if (null != expressionResult) {
                    JsonLd result;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Execution of the velocity expression completed successfully, as a result " + this.velocityInvocationContext.velocityJsonLd.object + " object was produced." + " I start serializing them."));
                    }
                    VmodlContext vimVmodlContext = VmodlContextProvider.getVmodlContextForPacakgeAndClass("com.vmware.vim.binding.vim", AboutInfo.class, false);
                    VmodlToJsonLdSerializer serializer = new VmodlToJsonLdSerializer(vimVmodlContext.getVmodlTypeMap(), Arrays.asList("com.vmware.vim.binding.vim"));
                    JsonLd jsonLd = result = new VelocityJsonLdToJsonLdConverter().convert(this.velocityInvocationContext.velocityJsonLd.object, serializer);
                    return jsonLd;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Execution of the velocity expression did not complete successfully, return nothing (null).");
                }
                JsonLd jsonLd = null;
                return jsonLd;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("This mapping contains no velocity code to produce results. Skipping this mapping: " + this));
            }
            JsonLd jsonLd = null;
            return jsonLd;
        }
        finally {
            this.velocityInvocationContext = null;
        }
    }

    protected boolean validateInput(NamedPropertiesResourceItem input) {
        String resultType;
        Object resourceObject = input.getResourceObject();
        if (resourceObject instanceof ManagedObjectReference) {
            ManagedObjectReference moRef = (ManagedObjectReference)resourceObject;
            resultType = moRef.getType();
        } else {
            resultType = resourceObject.getClass().getName();
        }
        if (!this._forType.isEmpty() && !this._forType.equals(resultType)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(this.getClass().getSimpleName() + " mapping is configured to process query results of type '" + this._forType + "' but was invoked with result of type  '" + resultType + "'. Skipping this mapping: " + this));
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [forType=" + this._forType + ", mappingCode=" + this._mappingCode + "]";
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }
}

