/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.cdf.mapping.velocity;

import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.RelatedResource;
import com.vmware.ph.client.api.commondataformat20.Payload20;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.cdf.mapping.QueryResultToDictionaryConverter;
import com.vmware.ph.phservice.collector.cdf.mapping.velocity.VelocityHelper;
import com.vmware.ph.phservice.common.cdf.CdfUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public abstract class VelocityResourceMapping<T>
implements Mapping<T, Resource>,
QueryResultToDictionaryConverter<T> {
    public static final Log logger = LogFactory.getLog(VelocityResourceMapping.class);
    private transient Payload20.Builder _payloadBuilder = new Payload20.Builder();
    private final String _idPattern;
    private final Map<String, String> _attributePatterns;
    private String _resourceType = "";
    private Map<String, String> _relationPatterns = new HashMap<String, String>();

    public VelocityResourceMapping(String resourceType, String idPattern, Map<String, String> attributePatterns, Map<String, String> relationPatterns) {
        this._resourceType = resourceType;
        this._idPattern = idPattern;
        this._attributePatterns = attributePatterns;
        this._relationPatterns = relationPatterns;
    }

    public Payload20 getPayload() {
        Payload20 payload = this._payloadBuilder.build();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Returning payload with. Resources count %d, Free Forms count %d and %d JSONs. A %d CDFs in total.", payload.getResources().size(), payload.getFreeforms().size(), payload.getJsons().size(), payload.getCdfs().size()));
        }
        return payload;
    }

    @Override
    public Resource map(T input, Context parentContext) {
        this._payloadBuilder = new Payload20.Builder();
        Map<String, Object> velocityDictionary = this.createDictionary(input);
        if (velocityDictionary == null) {
            return null;
        }
        VelocityContext context = VelocityHelper.createVelocityContextWithPredefinedGlobalObjects();
        VelocityHelper.updateContextWith(context, parentContext);
        VelocityHelper.updateContextWith(context, velocityDictionary);
        VelocityHelper.updateContextWith(context, this._payloadBuilder);
        VelocityEngine velocityEngine = VelocityHelper.createVelocityEngine();
        String id = VelocityHelper.executeVelocityExpression(this._idPattern, velocityEngine, context, "idPattern");
        if (id == null || id.trim().isEmpty()) {
            return null;
        }
        Resource.KeyValue[] attributes = this.buildAttributes(velocityEngine, context);
        RelatedResource[] relations = this.buildRelations(velocityEngine, context);
        Resource resource = new Resource(this._resourceType, id, attributes, relations);
        return resource;
    }

    protected RelatedResource[] buildRelations(VelocityEngine velocityEngine, VelocityContext substitutor) {
        ArrayList<RelatedResource> result = new ArrayList<RelatedResource>();
        if (this._relationPatterns != null) {
            for (Map.Entry<String, String> ent : this._relationPatterns.entrySet()) {
                String evaluated = VelocityHelper.executeVelocityExpression(ent.getValue(), velocityEngine, substitutor, ent.getKey());
                if (StringUtils.isBlank((String)evaluated)) continue;
                RelatedResource rr = new RelatedResource(ent.getKey(), evaluated);
                result.add(rr);
            }
        }
        return result.toArray(new RelatedResource[0]);
    }

    protected Resource.KeyValue[] buildAttributes(VelocityEngine velocityEngine, VelocityContext context) {
        if (this._attributePatterns == null) {
            return new Resource.KeyValue[0];
        }
        Map<String, Object> evaluatedAttributes = VelocityHelper.evaluateAttributes(this._attributePatterns, velocityEngine, context);
        return CdfUtil.convertMapToKeyValueArray(evaluatedAttributes);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

