/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.core.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.ph.common.audit.PayloadAuditPersister;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.CollectorOutcome;
import com.vmware.ph.phservice.PayloadAuditPersisterProvider;
import com.vmware.ph.phservice.collector.core.Collector;
import com.vmware.ph.phservice.collector.core.impl.UsageDataCollector;
import com.vmware.ph.phservice.collector.core.impl.UsageDataCollectorBuilder;
import com.vmware.ph.phservice.collector.core.impl.VcCollectorAgentProvider;
import com.vmware.ph.phservice.collector.core.impl.VcContextFactory;
import com.vmware.ph.phservice.collector.data.LocalQueryServiceFactory;
import com.vmware.ph.phservice.collector.data.impl.LocalQueryServiceFactoryImpl;
import com.vmware.ph.phservice.collector.manifest.Manifest;
import com.vmware.ph.phservice.collector.manifest.xml.XmlManifestProvider;
import com.vmware.ph.phservice.common.cdf.FileSystemManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.FileSystemPayloadUploader;
import com.vmware.ph.phservice.common.cdf.ManifestContentProvider;
import com.vmware.ph.phservice.common.cdf.PayloadUploader;
import com.vmware.ph.phservice.common.ph.AlwaysOnCeipConfigProvider;
import com.vmware.ph.phservice.common.ph.DefaultPhClientFactory;
import com.vmware.ph.phservice.common.ph.DefaultPhEnvironmentProvider;
import com.vmware.ph.phservice.common.ph.PhManifestContentProvider;
import com.vmware.ph.phservice.common.ph.PhPayloadUploader;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectorImpl
implements Collector {
    public static final String PHS_SKIP_LOCAL_PAYLOAD_UPLOADER = "phs.skipLocalPayloadUploader";
    public static final String PHS_SKIP_LOCAL_MANIFEST = "phs.skipLocalManifest";
    public static final String PROP_COLLECTOR_ID = "cmc.collector_id";
    public static final String PROP_INSTANCE_ID = "cmc.instance_id";
    public static final String PROP_CMC_TARGET_ENVIRONMENT = "cmc.target_environment";
    public static final String PROP_TARGET_PAYLOAD_LOCATION = "cmc.target_payload_location";
    public static final String PROP_MANIFEST_LOCATION = "cmc.manifest_location";
    private static final Log log = LogFactory.getLog(CollectorImpl.class);
    private final DataProvidersConnection _dataProvidersConnection;
    private final ExecutorService _executorService;
    private final UsageDataCollector _usageDataCollector;
    private final LocalQueryServiceFactory _localQueryServiceFactory = new LocalQueryServiceFactoryImpl();
    private CollectionPeriod _collectionPeriod = CollectionPeriod.WEEKLY;

    public CollectorImpl(DataProvidersConnection dataProvidersConnection, ManifestContentProvider manifestContentProvider, PayloadUploader resultPayloadUploader) {
        this(dataProvidersConnection, manifestContentProvider, resultPayloadUploader, new Properties());
    }

    public CollectorImpl(DataProvidersConnection dataProvidersConnection, ManifestContentProvider manifestContentProvider, PayloadUploader resultPayloadUploader, Properties properties) {
        this(dataProvidersConnection, manifestContentProvider, resultPayloadUploader, null, null, properties, null, CollectionPeriod.WEEKLY);
    }

    public CollectorImpl(DataProvidersConnection dataProvidersConnection, ManifestContentProvider manifestContentProvider, PayloadUploader resultPayloadUploader, PayloadAuditPersisterProvider payloadAuditPersisterProvider, ProxySettingsProvider proxySettingsProvider, Properties properties, VcClientProvider vcClientProvider, CollectionPeriod collectionPeriod) {
        Validate.notNull((Object)dataProvidersConnection);
        this._dataProvidersConnection = dataProvidersConnection;
        this._executorService = Executors.newSingleThreadExecutor();
        VcContextFactory vcContextFactory = new VcContextFactory(vcClientProvider);
        VcCollectorAgentProvider vcCollectorAgentProvider = new VcCollectorAgentProvider(vcClientProvider, properties.getProperty(PROP_COLLECTOR_ID), properties.getProperty(PROP_INSTANCE_ID));
        if (manifestContentProvider == null) {
            manifestContentProvider = CollectorImpl.getManifestContentProvider(properties, payloadAuditPersisterProvider, proxySettingsProvider);
        }
        if (resultPayloadUploader == null) {
            resultPayloadUploader = CollectorImpl.getPayloadUploader(properties, payloadAuditPersisterProvider, proxySettingsProvider, this._executorService);
        }
        this._usageDataCollector = new UsageDataCollectorBuilder(vcContextFactory, vcCollectorAgentProvider, manifestContentProvider, resultPayloadUploader).build();
        this._collectionPeriod = collectionPeriod;
    }

    @Override
    public void run() {
        List<DataProvider> dataProviders = null;
        try {
            dataProviders = this._dataProvidersConnection.getDataProviders();
        }
        catch (Exception e) {
            log.error((Object)"Error while getting the data providers list.", (Throwable)e);
            throw new RuntimeException(e);
        }
        Validate.notNull(dataProviders, (String)"The dataProviders list is null.");
        QueryService queryService = this._localQueryServiceFactory.getQueryService(dataProviders);
        try {
            Manifest manifestToExecute = this.getManifest(this._usageDataCollector.getPhClientManifest());
            if (manifestToExecute == null) {
                return;
            }
            CollectorOutcome collectorOutcome = this._usageDataCollector.collect(queryService, manifestToExecute);
            if (!CollectorOutcome.PASSED.equals((Object)collectorOutcome)) {
                throw new RuntimeException("Usage data collection failed!");
            }
        }
        catch (ManifestContentProvider.ManifestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this._executorService.shutdown();
    }

    Manifest getManifest(String manifest) {
        XmlManifestProvider provider = new XmlManifestProvider(manifest, this._collectionPeriod);
        return provider.getManifest();
    }

    private static ManifestContentProvider getManifestContentProvider(Properties properties, PayloadAuditPersisterProvider payloadAuditPersisterProvider, ProxySettingsProvider proxySettingsProvider) {
        String manifestFilePathName;
        ManifestContentProvider manifestContentProvider = null;
        boolean skipLocalManifest = Boolean.parseBoolean(properties.getProperty(PHS_SKIP_LOCAL_MANIFEST, "false"));
        if (!skipLocalManifest && (manifestFilePathName = properties.getProperty(PROP_MANIFEST_LOCATION)) != null) {
            manifestContentProvider = new FileSystemManifestContentProvider(manifestFilePathName);
        }
        if (manifestContentProvider == null) {
            DefaultPhEnvironmentProvider phEnvironmentProvider = new DefaultPhEnvironmentProvider(properties.getProperty(PROP_CMC_TARGET_ENVIRONMENT));
            DefaultPhClientFactory phClientFactory = new DefaultPhClientFactory(phEnvironmentProvider, CollectorImpl.createPayloadAuditPersisterProviderAdapter(payloadAuditPersisterProvider), proxySettingsProvider, new AlwaysOnCeipConfigProvider());
            manifestContentProvider = new PhManifestContentProvider(phClientFactory);
        }
        return manifestContentProvider;
    }

    private static PayloadUploader getPayloadUploader(Properties properties, PayloadAuditPersisterProvider payloadAuditPersisterProvider, ProxySettingsProvider proxySettingsProvider, ExecutorService executorService) {
        String outputDir;
        PayloadUploader payloadUploader = null;
        boolean skipLocalPayloadUploader = Boolean.parseBoolean(properties.getProperty(PHS_SKIP_LOCAL_PAYLOAD_UPLOADER, "false"));
        if (!skipLocalPayloadUploader && (outputDir = properties.getProperty(PROP_TARGET_PAYLOAD_LOCATION)) != null) {
            payloadUploader = new FileSystemPayloadUploader(outputDir, executorService);
        }
        if (payloadUploader == null) {
            DefaultPhEnvironmentProvider phEnvironmentProvider = new DefaultPhEnvironmentProvider(properties.getProperty(PROP_CMC_TARGET_ENVIRONMENT));
            DefaultPhClientFactory phClientFactory = new DefaultPhClientFactory(phEnvironmentProvider, CollectorImpl.createPayloadAuditPersisterProviderAdapter(payloadAuditPersisterProvider), proxySettingsProvider, new AlwaysOnCeipConfigProvider());
            payloadUploader = new PhPayloadUploader(phClientFactory, executorService);
        }
        return payloadUploader;
    }

    private static com.vmware.ph.phservice.common.ph.PayloadAuditPersisterProvider createPayloadAuditPersisterProviderAdapter(final PayloadAuditPersisterProvider payloadAuditPersisterProvider) {
        if (payloadAuditPersisterProvider == null) {
            return null;
        }
        return new com.vmware.ph.phservice.common.ph.PayloadAuditPersisterProvider(){

            @Override
            public PayloadAuditPersister getPayloadAuditPersister() {
                return payloadAuditPersisterProvider.getPayloadAuditPersister();
            }
        };
    }
}

