/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.core.impl;

import com.vmware.ph.phservice.common.PersistenceService;
import com.vmware.ph.phservice.common.PersistenceServiceException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public class PropertiesFilePersistenceService
implements PersistenceService {
    private static final Log _log = LogFactory.getLog(PropertiesFilePersistenceService.class);
    private final File _persistenceFile;

    public PropertiesFilePersistenceService(ClassPathResource persistenceFileResource) throws IOException {
        this._persistenceFile = persistenceFileResource.getFile();
    }

    @Override
    public String readString(String key) throws PersistenceServiceException {
        return this.readValue(key);
    }

    @Override
    public Long readLong(String key) throws PersistenceServiceException {
        Long result = null;
        String rawValue = this.readValue(key);
        if (rawValue != null) {
            try {
                result = Long.parseLong(rawValue);
            }
            catch (NumberFormatException e) {
                _log.warn((Object)String.format("Caught exception while trying to convert value for key %s", key), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void writeString(String key, String value) throws PersistenceServiceException {
        this.writeValue(key, value);
    }

    @Override
    public void writeLong(String key, long value) throws PersistenceServiceException {
        this.writeValue(key, Long.toString(value));
    }

    private String readValue(String key) throws PersistenceServiceException {
        Objects.requireNonNull(key);
        Properties props = this.readPropertiesFromFile();
        return props.getProperty(key);
    }

    private void writeValue(String key, String value) throws PersistenceServiceException {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Properties props = this.readPropertiesFromFile();
        props.setProperty(key, value);
        this.writePropertiesToFile(props);
    }

    private Properties readPropertiesFromFile() throws PersistenceServiceException {
        Properties props = new Properties();
        try (FileReader reader = new FileReader(this._persistenceFile);){
            props.load(reader);
        }
        catch (IOException e) {
            String message = String.format("Caught exception while trying to read persistence file %s.", this._persistenceFile);
            throw new PersistenceServiceException(message, e);
        }
        return props;
    }

    private void writePropertiesToFile(Properties props) throws PersistenceServiceException {
        try (FileWriter writer = new FileWriter(this._persistenceFile);){
            props.store(writer, null);
        }
        catch (IOException e) {
            String message = String.format("Caught exception while trying to write to persistence file %s.", this._persistenceFile);
            throw new PersistenceServiceException(message, e);
        }
    }
}

