/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.core.impl;

import com.vmware.ph.phservice.collector.core.impl.CollectorAgentProvider;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClient;
import com.vmware.ph.phservice.provider.vimcommon.vc.VcClientProvider;
import org.apache.commons.lang.StringUtils;

public class VcCollectorAgentProvider
implements CollectorAgentProvider {
    private static final String DEFAULT_COLLECTOR_ID = "vSphere.7_0";
    private final VcClientProvider _vcClientProvider;
    private final String _collectorId;
    private final String _collectorInstanceId;

    public VcCollectorAgentProvider(VcClientProvider vcClientProvider, String collectorId, String collectorInstanceId) {
        this._vcClientProvider = vcClientProvider;
        this._collectorId = collectorId;
        this._collectorInstanceId = collectorInstanceId;
    }

    @Override
    public String getCollectorId() {
        String result = DEFAULT_COLLECTOR_ID;
        if (StringUtils.isNotBlank((String)this._collectorId)) {
            result = this._collectorId;
        }
        return result;
    }

    @Override
    public String getCollectorInstanceId() {
        String instanceId;
        if (StringUtils.isNotBlank((String)this._collectorInstanceId)) {
            instanceId = this._collectorInstanceId;
        } else {
            String vcServiceGuid = this.getVcGuid(this._vcClientProvider);
            instanceId = "ph-" + vcServiceGuid;
        }
        return instanceId;
    }

    private String getVcGuid(VcClientProvider vcClientProvider) {
        VcClient vcClient = vcClientProvider.getVcClient();
        String vcGuid = vcClient.getServiceInstanceContent().getAbout().getInstanceUuid();
        return vcGuid;
    }
}

