/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.data;

import com.vmware.cis.data.api.Query;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class NamedQuery {
    private final Query _query;
    private final String _name;
    private final Double _cpuThreshold;
    private final Double _memoryThreshold;

    public NamedQuery(Query query, String name) {
        this(query, name, null, null);
    }

    public NamedQuery(Query query, String name, Double cpuThreshold, Double memoryThreshold) {
        assert (query != null);
        this._query = query;
        this._name = name;
        this._cpuThreshold = cpuThreshold;
        this._memoryThreshold = memoryThreshold;
    }

    public Query getQuery() {
        return this._query;
    }

    public String getName() {
        return this._name;
    }

    public Double getCpuThreshold() {
        return this._cpuThreshold;
    }

    public Double getMemoryThreshold() {
        return this._memoryThreshold;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Query name: ").append(this._name).append(System.lineSeparator());
        stringBuilder.append("Query: ").append(this._query).append(System.lineSeparator());
        stringBuilder.append("Query thresholds: [").append(this._cpuThreshold).append("] CPU, [");
        stringBuilder.append(this._memoryThreshold).append("] memory");
        return stringBuilder.toString();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this._query).append((Object)this._name).append((Object)this._cpuThreshold).append((Object)this._memoryThreshold).toHashCode();
    }
}

