/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.data;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.ph.phservice.collector.data.NamedQuery;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryPagingIterator
implements Iterator<ResultSet> {
    private static final Log _log = LogFactory.getLog(QueryPagingIterator.class);
    private static final int NO_RESULT_SET_YET = -1;
    private final NamedQuery _baseNamedQuery;
    private final int _forcedMaxResultCount;
    private final AtomicInteger _currObjectCounter;
    private final QueryService _queryService;
    private final String _estTotalPages;
    private int _pageSize;
    private int _currentResultSetItemCount;
    private int _currentOffset;
    private int _currentPageIndex;

    public QueryPagingIterator(NamedQuery namedQuery, int pageSize, QueryService queryService) {
        this._baseNamedQuery = namedQuery;
        this._queryService = queryService;
        int queryLimit = namedQuery.getQuery().getLimit();
        this._forcedMaxResultCount = queryLimit < 0 ? Integer.MAX_VALUE : queryLimit;
        this._pageSize = Math.min(pageSize, this._forcedMaxResultCount);
        this._currentResultSetItemCount = -1;
        this._currentOffset = 0;
        this._currentPageIndex = 0;
        this._currObjectCounter = new AtomicInteger();
        this._estTotalPages = this._forcedMaxResultCount < Integer.MAX_VALUE ? String.valueOf((this._forcedMaxResultCount + pageSize - 1) / pageSize) : "unknown";
    }

    public String getPageInfo() {
        return "page " + this._currentPageIndex + " of " + this._estTotalPages;
    }

    public NamedQuery getBaseNamedQuery() {
        return this._baseNamedQuery;
    }

    public int getCurrentPageIndex() {
        return this._currentPageIndex;
    }

    @Override
    public boolean hasNext() {
        return this._currentResultSetItemCount == -1 || this._currentResultSetItemCount == this._pageSize && this._currentOffset < this._forcedMaxResultCount;
    }

    @Override
    public ResultSet next() {
        this._pageSize = Math.min(this._pageSize, this._forcedMaxResultCount - this._currentOffset);
        NamedQuery nextPageQuery = this.getQueryForNextPage();
        QueryCommand nextPageQueryCommand = QueryPagingIterator.buildQueryCommandFromQuery(nextPageQuery.getQuery(), this._queryService);
        ResultSet nextPageResultSet = nextPageQueryCommand.fetch();
        List nextPageResultItems = nextPageResultSet.getItems();
        if (nextPageResultItems.isEmpty()) {
            this._currentResultSetItemCount = 0;
        } else {
            this._currentResultSetItemCount = nextPageResultItems.size();
            if (this._currentResultSetItemCount > this._pageSize && _log.isWarnEnabled()) {
                _log.warn((Object)String.format("The following query returned %s items with a limit of %s. This is an issue with the underlying DataProvider since the contract isn't respected:\n %s", this._currentResultSetItemCount, this._pageSize, nextPageQuery));
            }
        }
        this._currentOffset += this._currentResultSetItemCount;
        ++this._currentPageIndex;
        return nextPageResultSet;
    }

    public AtomicInteger getCurrentObjectCounter() {
        return this._currObjectCounter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private NamedQuery getQueryForNextPage() {
        Query baseQuery = this._baseNamedQuery.getQuery();
        Query.Builder nextQueryBuilder = Query.Builder.select((List)baseQuery.getProperties()).from(baseQuery.getResourceModels()).offset(this._currentOffset).limit(this._pageSize).where(baseQuery.getFilter()).orderBy(baseQuery.getSortCriteria());
        if (baseQuery.getWithTotalCount() || baseQuery.getLimit() == 0 || baseQuery.getLimit() == -1) {
            nextQueryBuilder.withTotalCount();
        }
        Query nextQuery = nextQueryBuilder.build();
        return new NamedQuery(nextQuery, this._baseNamedQuery.getName());
    }

    public static QueryCommand buildQueryCommandFromQuery(Query query, QueryService queryService) {
        QueryCommand.Builder queryCommandBuilder = queryService.select(query.getProperties()).from(query.getResourceModels()).offset(query.getOffset()).limit(query.getLimit()).where(query.getFilter()).orderBy(query.getSortCriteria());
        if (query.getWithTotalCount()) {
            queryCommandBuilder.withTotalCount();
        }
        return queryCommandBuilder.build();
    }
}

