/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.file;

import com.vmware.cis.data.api.QueryService;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.NamedQueryResultSetMapping;
import com.vmware.ph.phservice.collector.data.NamedQuery;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import com.vmware.ph.phservice.collector.data.QueryServiceCollector;
import com.vmware.ph.phservice.collector.file.CollectedFile;
import com.vmware.ph.phservice.collector.file.FileCollector;
import com.vmware.ph.phservice.collector.manifest.Manifest;
import java.io.File;

public class QueryServiceFileCollector
implements FileCollector {
    private final QueryServiceCollector<CollectedFile> _qsCollector = new QueryServiceCollector();

    @Override
    public Iterable<CollectedFile> collect(Manifest manifest, QueryService queryService, Context context, int pageSize) {
        NamedQuery[] queries = manifest.getQueries();
        NamedQueryResultSetMapping<File> fileMapping = manifest.getFileMapping();
        NamedQueryResultSetToCollectedFileMapping resultMapping = new NamedQueryResultSetToCollectedFileMapping(fileMapping);
        Iterable<CollectedFile> result = this._qsCollector.collect(queries, resultMapping, queryService, context, pageSize);
        return result;
    }

    static class NamedQueryResultSetToCollectedFileMapping
    implements NamedQueryResultSetMapping<CollectedFile> {
        NamedQueryResultSetMapping<File> _resultSetToFileMapping;

        public NamedQueryResultSetToCollectedFileMapping(NamedQueryResultSetMapping<File> resultSetToFileMapping) {
            this._resultSetToFileMapping = resultSetToFileMapping;
        }

        @Override
        public CollectedFile map(NamedQueryResultSet input, Context context) {
            File file = (File)this._resultSetToFileMapping.map(input, context);
            CollectedFile.Builder builder = new CollectedFile.Builder();
            builder.setFile(file);
            builder.onDisposeDelete();
            return builder.build();
        }

        @Override
        public boolean isQuerySupported(String queryName) {
            return this._resultSetToFileMapping.isQuerySupported(queryName);
        }
    }
}

