/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ph.phservice.collector.file.mapping;

import com.vmware.cis.data.api.ResultSet;
import com.vmware.ph.phservice.collector.Context;
import com.vmware.ph.phservice.collector.NamedQueryResultSetMapping;
import com.vmware.ph.phservice.collector.cdf.mapping.Mapping;
import com.vmware.ph.phservice.collector.data.NamedQueryResultSet;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IndependentFileMappings
implements NamedQueryResultSetMapping<File> {
    private final Map<String, Mapping<ResultSet, File>> _queryNameToFileMapping;

    public IndependentFileMappings() {
        this._queryNameToFileMapping = new HashMap<String, Mapping<ResultSet, File>>();
    }

    public IndependentFileMappings(Map<String, Mapping<ResultSet, File>> queryNameToFileMapping) {
        this._queryNameToFileMapping = Collections.unmodifiableMap(queryNameToFileMapping);
    }

    @Override
    public File map(NamedQueryResultSet input, Context context) {
        if (input == null) {
            return null;
        }
        Mapping<ResultSet, File> queryNameToFileMapping = this._queryNameToFileMapping.get(input.getQueryName());
        File file = null;
        if (queryNameToFileMapping != null) {
            file = queryNameToFileMapping.map(input.getResultSet(), context);
        }
        return file;
    }

    @Override
    public boolean isQuerySupported(String queryName) {
        return this._queryNameToFileMapping.containsKey(queryName);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)obj, (Object)this);
    }

    public String toString() {
        return "IndependentFileMappings [independentFileMappings=" + this._queryNameToFileMapping + "]";
    }
}

